<?php
/**
 * @package Packages
 */

/** Horde_RDO */
require_once 'Horde/RDO.php';
require_once 'Horde/RDO/Adapter.php';

/** Lens */
require_once dirname(__FILE__) . '/Lens.php';

/** Horde_Cache */
require_once 'Horde/Cache.php';

/** Horde_Http */
require_once 'Horde/Http.php';

/**
 * Packages Base Class.
 *
 * $Horde: $
 *
 * Copyright 2004-2007 Your Name <you@example.com>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Your Name <you@example.com>
 * @package Packages
 */
class Packages {

    /**
     */
    function remoteBox($url)
    {
        return 'RedBox.loading(); new Ajax.Request(\'' . addslashes($url) . '\', { method: \'get\', onComplete: function(transport, object) { RedBox.showHtml(transport.responseText); table_init(); } }); return false;';
    }

    function closeBox()
    {
        return '<input type="button" class="button" onclick="RedBox.close(); return false;" value="' . _("Close") . '" />';
    }

    /**
     * Build the list of menu items.
     */
    function getMenu($returnType = 'object')
    {
        Horde::addScriptFile('open_calendar.js', 'horde');
        Horde::addScriptFile('prototype.js', 'horde', true);
        Horde::addScriptFile('effects.js', 'packages', true);
        Horde::addScriptFile('redbox.js', 'packages', true);

        require_once 'Horde/Menu.php';

        $menu = new Menu(HORDE_MENU_MASK_ALL);
        $menu->add(Horde::applicationUrl('packages.php'), _("_My Packages"), 'packages.png');
        if (Auth::getAuth()) {
            $menu->add(Horde::applicationUrl('package/add.php'), _("_New Package"), 'add.png', null, null, Packages::remoteBox(Horde::applicationUrl('package/add.php?partial=1')));
        }

        if ($returnType == 'object') {
            return $menu;
        } else {
            return $menu->render();
        }
    }

}

/**
 *
 */
class Package extends Horde_RDO {

    public function map()
    {
        return 'http://www.packagemapping.com/track/t_trackmap.php?access_key=&tracknum=1Z12345E1512345676';
    }

    public function toString()
    {
        $hist = $this->history();
        $history = '';
        if (is_string($hist)) {
            $history = $hist;
        } else {
            foreach ($hist as $item) {
                $history .= $item->title . "\n" . $item->description . "\n\n";
            }
        }

        return $this->package_name . "\n\n"
            . ($this->package_notes ? sprintf("Notes: %s\n\n", $this->package_notes) : '')
            . $history;
    }

    public function history()
    {
        if (!$this->package_tracking) {
            if ($this->package_exp_date) {
                return sprintf(_("Expected on: %s"), strftime($GLOBALS['prefs']->getValue('date_format'), $this->package_exp_date));
            } else {
                return '';
            }
        }

        $cacheId = $this->package_id;
        $ctime = time() - 3600; // cache for an hour
        $cache = Horde_Cache::factory($GLOBALS['conf']['cache']['driver'],
                                      Horde::getDriverConfig('cache', $GLOBALS['conf']['cache']['driver']));
        if ($cache->exists($cacheId, $ctime)) {
            $xml = $cache->get($cacheId, $ctime);
        } else {
            $url = 'http://www.packagemapping.com/track/tracking.php?action=track&tracknum=' . urlencode($this->package_tracking) . '&rss=1';
            $client = new Horde_Http_Client();
            $resp = $client->GET($url);
            $xml = $resp->getBody();
            $cache->set($cacheId, $xml);
        }

        $rss = simplexml_load_string($xml);
        if (strpos($rss->channel->description, 'ERROR') !== false) {
            return array();
        }
        return $rss->channel->item;
    }

}

/**
 */
class PackageMapper extends Horde_RDO_Mapper {

    protected $_table = 'packages';

    public function getAdapter()
    {
        return Horde_RDO_Adapter::factory('pdo', $GLOBALS['conf']['sql']);
    }

    public function create($fields)
    {
        $fields['list_id'] = Auth::getAuth();
        return parent::create($fields);
    }

    public function find($mode = null, $query = null)
    {
        if (is_null($query)) {
            $query = array('list_id' => Auth::getAuth());
            if (is_int($mode)) {
                $query['package_id'] = $mode;
                $mode = Horde_RDO::FIND_FIRST;
            }
        } elseif (is_array($query)) {
            $query['list_id'] = Auth::getAuth();
        } else {
            $query->addTest('list_id', '=', Auth::getAuth());
        }

        return parent::find($mode, $query);
    }

}

/**
 */
class PackageLens extends Horde_RDO_Lens {

    /**
     */
    private $date_format = '%x';

    /**
     */
    private $time_format = 'G:i';

    /**
     */
    public function __construct()
    {
        $this->date_format = $GLOBALS['prefs']->getValue('date_format');
        $this->time_format = $GLOBALS['prefs']->getValue('twentyFour') ? 'G:i' : 'g:ia';
    }

    /**
     */
    public function __get($key)
    {
        $value = parent::__get($key);
        if ($key == 'package_exp_date') {
            return strftime($this->date_format, $value) . ' ' . date($this->time_format , $value);
        }
        return htmlspecialchars($value, ENT_QUOTES, NLS::getCharset());
    }

}
