/**
 * Redbox.js
 *
 * $Horde: imp/js/src/redbox.js,v 1.4 2007/01/04 07:06:42 slusarz Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

var RedBox = {

    overlay: true,

    showInline: function(id)
    {
        this.showOverlay();
        new Effect.Appear('RB_window', { duration: 0.4, queue: 'end' });
        Element.scrollTo('RB_window');
        this.cloneWindowContents(id);
    },

    showHtml: function(html)
    {
        this.showOverlay();
        new Effect.Appear('RB_window', { duration: 0.4, queue: 'end' });
        Element.scrollTo('RB_window');
        this.htmlWindowContents(html);
    },

    loading: function()
    {
        this.showOverlay();
        Element.show('RB_loading');
        this.setWindowPosition();
    },

    addHiddenContent: function(id)
    {
        this.removeChildrenFromNode($('RB_window'));
        this.moveChildren($(id), $('RB_window'));
        Element.hide('RB_loading');
        new Effect.Appear('RB_window', { duration: 0.4, queue: 'end' });
        Element.scrollTo('RB_window');
        this.setWindowPosition();
    },

    close: function()
    {
        new Effect.Fade('RB_window', { duration: 0.4 });
        if (this.overlay) {
            new Effect.Fade('RB_overlay', { duration: 0.4 });
        }
    },

    showOverlay: function()
    {
        var rb = $('RB_redbox');
        if (rb) {
            Element.update(rb, '');
        } else {
            new Insertion.Bottom(document.body, '<div id="RB_redbox" align="center"></div>');
            rb = $('RB_redbox');
        }
        new Insertion.Top(rb, '<div id="RB_window" style="display: none;"></div><div id="RB_overlay" style="display: none;"></div>');

        if (this.overlay) {
            new Insertion.Top('RB_overlay', '<div id="RB_loading" style="display: none"></div>');
            this.setOverlaySize();
            new Effect.Appear('RB_overlay', { duration: 0.4, to: 0.6, queue: 'end' });
        }
    },

    setOverlaySize: function()
    {
        if (window.innerHeight && window.scrollMaxY) {
            yScroll = window.innerHeight + window.scrollMaxY;
        } else if (document.body.scrollHeight > document.body.offsetHeight) {
            // all but Explorer Mac
            yScroll = document.body.scrollHeight;
        } else {
            // Explorer Mac...would also work in Explorer 6 Strict, Mozilla
            // and Safari
            yScroll = document.body.offsetHeight;
        }
        Element.setStyle('RB_overlay', { height: yScroll + 'px' });
    },

    setWindowPosition: function()
    {
        var pagesize = this.getPageSize(), win = $('RB_window');
        var d = Element.getDimensions(win);
        Element.setStyle(win, { width: 'auto', height: 'auto', left: ((pagesize[0] - d.width) / 2) + 'px', top: ((pagesize[1] - d.height) / 2) + 'px' });
    },

    getPageSize: function()
    {
        var de = document.documentElement;
        var w = window.innerWidth || self.innerWidth || (de && de.clientWidth) || document.body.clientWidth;
        var h = window.innerHeight || self.innerHeight || (de && de.clientHeight) || document.body.clientHeight;

        return [w, h];
    },

    removeChildrenFromNode: function(node)
    {
        while (node.hasChildNodes()) {
            node.removeChild(node.firstChild);
        }
    },

    moveChildren: function(source, destination)
    {
        while (source.hasChildNodes()) {
            destination.appendChild(source.firstChild);
        }
    },

    cloneWindowContents: function(id)
    {
        var content = $(id).cloneNode(true);
        Element.setStyle(content, { display: 'block' });
        $('RB_window').appendChild(content);
        this.setWindowPosition();
    },

    htmlWindowContents: function(html)
    {
        Element.update('RB_window', html);
        this.setWindowPosition();
    }

}
