<?php
class PackageListView {

    function PackageListView($packages = null)
    {
        if (is_null($packages)) {
            $mapper = new PackageMapper();
            $packages = $mapper->find(Horde_RDO::FIND_ALL);
        }

        $this->packages = new Horde_RDO_Decorating_Iterator($packages, new PackageLens());
        $this->sortby = $GLOBALS['prefs']->getValue('sortby');
        $this->sortdir = $GLOBALS['prefs']->getValue('sortdir');
        $this->sortdirclass = ' class="' . ($this->sortdir ? 'sortup' : 'sortdown') . '"';

        Horde::addScriptFile('tables.js', 'horde', true);
        Horde::addScriptFile('prototype.js', 'horde', true);
        Horde::addScriptFile('effects.js', 'packages', true);
        Horde::addScriptFile('redbox.js', 'packages', true);
    }

    function render()
    {
        include PACKAGES_TEMPLATES . '/PackageList.php';
    }

}
