<?php
/**
 * External Interfaces.
 */

$_services['browse'] = array(
    'args' => array('path' => 'string'),
    'type' => '{urn:horde}hashHash',
);

$_services['addPackage'] = array(
    'args' => array('name' => 'string',
                    ),
    'type' => 'string',
);

$_services['listPackages'] = array(
    'args' => array(),
    'type' => '{urn:horde}stringArray',
);

function _packages_listPackages()
{
    require_once dirname(__FILE__) . '/base.php';

    $pm = new PackageMapper();
    $packages = array();
    foreach ($pm->find(Horde_RDO::FIND_ALL) as $p) {
        $packages[$p->package_id] = $p->package_name;
    }

    return $packages;
}

function _packages_addPackage($name)
{
    require_once dirname(__FILE__) . '/base.php';

    $pm = new PackageMapper();
    $package = $pm->create(array('name' => $name));
    return $package->package_id;
}

/**
 * Browse through the object tree.
 *
 * @param string $path       The level of the tree to browse.
 * @param array $properties  The item properties to return. Defaults to 'name',
 *                           'icon', and 'browseable'.
 *
 * @return array  The contents of $path
 */
function _packages_browse($path = '', $properties = array())
{
    require_once dirname(__FILE__) . '/base.php';

    // Default properties.
    if (!$properties) {
        $properties = array('name', 'icon', 'browseable');
    }

    if (substr($path, 0, 8) == 'packages') {
        $path = substr($path, 8);
    }
    $path = trim($path, '/');

    $pm = new PackageMapper();
    $packages = _packages_listPackages();

    if (empty($path)) {
        $results = array();
        foreach ($packages as $id => $name) {
            $results['packages/' . rawurlencode($name) . '.txt'] =
                array('name' => $name,
                      'icon' => $GLOBALS['registry']->getImageDir('horde') . '/about.png',
                      'browseable' => false,
                      'contenttype' => 'text/plain',
                      'contentlength' => strlen($pm->find((int)$id)->toString()));
        }
        return $results;
    } else {
        $name = str_replace('.txt', '', $path);
        $p = $pm->find(Horde_RDO::FIND_FIRST, array('package_name' => $name));
        if ($p instanceof Package) {
            return array('data' => $p->toString(),
                         'mimetype' => 'text/plain');
        }
    }

    return PEAR::raiseError($path . ' does not exist or permission denied');
}
