<?php
/**
 * Skeleton base application file.
 *
 * $Horde: skeleton/lib/base.php,v 1.14 2005/10/13 04:28:29 selsky Exp $
 *
 * This file brings in all of the dependencies that every Skeleton
 * script will need, and sets up objects that all scripts use.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/core.php';

// Registry.
$registry = &Registry::singleton();
if (is_a(($pushed = $registry->pushApp('packages', !defined('AUTH_HANDLER'))), 'PEAR_Error')) {
    if ($pushed->getCode() == 'permission_denied') {
        Horde::authenticationFailureRedirect();
    }
    Horde::fatal($pushed, __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('PACKAGES_TEMPLATES', $registry->get('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Define the base file path of Skeleton.
@define('PACKAGES_BASE', dirname(__FILE__) . '/..');

// Base library
require_once PACKAGES_BASE . '/lib/Packages.php';

// Horde libs
require_once 'Horde/Variables.php';
require_once 'Horde/Form.php';
require_once 'Horde/Form/Renderer.php';

// Start output compression.
Horde::compressOutput();
