<?php
/**
 * $Horde: $
 *
 * Copyright 2004-2007 Your Name <you@example.com>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('PACKAGES_BASE', dirname(dirname(__FILE__)));
require_once PACKAGES_BASE . '/lib/base.php';
require_once PACKAGES_BASE . '/lib/Forms/AddPackage.php';

$title = _("Add Package");
$vars = Variables::getDefaultVariables();

$form = new AddPackageForm($vars);
if ($form->validate()) {
    $pm = new PackageMapper();
    $form->getInfo(null, $info);
    $p = $pm->create(array('package_name' => $info['package_name'],
                           'package_tracking' => $info['package_tracking'],
                           'package_exp_date' => $info['package_exp_date'],
                           'package_notes' => $info['package_notes']));
    if ($p instanceof Package) {
        header('Location: ' . Horde::applicationUrl('packages.php', true));
        exit;
    }
}

$partial = $vars->partial;
if ($partial) {
    echo Packages::closeBox() . '<br /><div id="RB_content">';
} else {
    require PACKAGES_TEMPLATES . '/common-header.inc';
    require PACKAGES_TEMPLATES . '/menu.inc';
}

echo $form->renderActive(null, null, Horde::applicationUrl('package/add.php'));

if ($partial) {
    echo '</div>';
} else {
    require $registry->get('templates', 'horde') . '/common-footer.inc';
}
