--
-- Table structure for table `properties`
--

CREATE TABLE properties (
  id serial NOT NULL,
  mls integer default NULL,
  shortlist char(1) NOT NULL default '',
  address varchar(100) default NULL,
  neighborhood varchar(50) default NULL,
  unit_1 varchar(10) default NULL,
  unit_2 varchar(10) default NULL,
  sf integer default NULL,
  expansion char(1) default NULL,
  garage char(1) default NULL,
  renovated char(1) default NULL,
  mbta varchar(10) default NULL,
  date integer default NULL,
  price integer default NULL,
  description text,
  c_comments text,
  j_comments text,
  s_comments text,
  w_comments text,
  sasha_comments text,
  url varchar(255) default NULL,
  photo varchar(255) default NULL,
  latitude float default NULL,
  longitude float default NULL,
  active integer NOT NULL default '0',
  PRIMARY KEY  (id)
);

--
-- Dumping data for table properties
--

INSERT INTO properties VALUES (22,70199738,'n','Edson St, 37','','5/3/2','10/6/1',3489,'y','n','n','0.35 (JFK)',NULL,489900,'Deactivated 3/5: No one liked it.\r\n\r\n\"Nice Large 3 Story 2 Family Home Newer Vinyl Windows.  No Disclosures.\"\r\n\r\nBuilt in 1910.','T stop is across the highway (should be a walkway, but ...) and there looks to be little services around - Uphams Corner is closest. Inclined to drop it.','Not particularly appealing to me.  Without interior photos tempting me, I can\'t prefer it to anything.  So many better options.  ***  C & I would eliminate this one.','This strikes me as pretty ugly.','Negative reaction; looks like an inoperative car parked in the grass next door.','the lot with the car art could be built upon and you\'d lose a whole exposure.  not so pretty walk to T.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010185993','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2424105',42.3194,-71.059,1);
INSERT INTO properties VALUES (23,70309619,'n','Ashmont St, 3','Ashmont Hill','3/1/1','7/5/3',2500,'y','n','y','0.58 (A)',NULL,550000,'Deactivated 3/5: Given price, distance from transit, and 3/1/1 unit #1, not worth considering further.\r\n\r\n\"Beautiful, brand new renovations have been made to this lovely two-family home in the desireable Ashmont Hill area. This ready to move-in home features hardwood floors throughout, separate utilities, updated electrical w/ panels in each unit, insulated windows, 3-year old roof, partially finished basement, and off-street parking. Broker is owner and willing to assist with up to $10K in closing costs.\"\r\n\r\nBuilt in 1920.  The partially finished basement provides expansion options for the first floor.',NULL,NULL,NULL,'Unit 1 tiny. Don\'t like looks of cars parked in front of house, in the front \"yard\". smacks of hillbilly country. Pos. is apparent condition.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010441040','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2704447',42.2884,-71.0543,1);
INSERT INTO properties VALUES (24,70260779,'y','Wellesley Pk, 4','Melville Park','8/4/1.5','7/4/1',4065,'y','y','n','0.25 (S)',1126756800,470000,'3/28 - price reduction from $520,000.  Agent says he has an offer, but is still showing, because prior buyers have failed financing.\r\n\r\n3/17 update after exterior viewing: Very scared of the amount of repair which would be necessary.  Of even being able to properly asses what needs to be done and how much it might cost.  Broken windows and disrepair.  And nervous that there might be high pressure to do renovations faster than we would want, or to spend more than we would prefer, in a sense of historical obligation.  Such a grand street.  Gas lamps.  Garage is on adjacent street.\r\n\r\n\"Two family in much desired Melville Ave area in Dorchester. Hardwood floors throughout.  Much of original woodwork in great condition.  Needs work but lots of character.\"\r\n\r\nBuilt in 1890.  0.13 acres.  Corner lot.  Full basement with interior access. *Forced Hot Air* ','Almost as close to Fields Corner as to Shawmut. And Wellesley Park seems to be named because the loop that the road makes seems to enclose an actual park; nice open space.','This is the \"funky\" one we all have a fondness for.  Positives = Appearance, exterior very attractive in its irregularity, what looks like a bunch of trees around, porches, size (big for what we need)  Negs = vinyl, 1st fl larger, only 1 bath each, electrical not updated, costs associated with it being bigger, 1st floor is very large.  Also, we have been told the current owner is a not fully \"there\" and, if true, this may have resulted in upkeep consequences for the property.','This is _so_ appealing. You (C & J) could have a guest room and/or library chez us.:) I tend to think \"big is good.\" Condition is a big issue of course, along with the electrical, etc -  I wonder if we could get this for a lot less than list and renovate, given how long it\'s been on the market.','Lots of trees (positive). sattelite image suggests spacious surroundings','The location is stunning -- Nina would be in heaven with the gas lamp park, but a closer look even from the curb reveals a house that needs a lot of TLC. It could be a big project because of the size of it.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010321911','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2578118',42.297,-71.0656,1);
INSERT INTO properties VALUES (25,70270758,'n','Callender St, 219*','?','5/2/1','6/3/1',2404,'y','n','?','0.56 (MS)',1128139200,429900,'3/18 Deactivating commuter rail properties\r\n\r\n\"2 Family with the right price! Needs work. Located on a quiet street close to all amenities. Apartments feature a 2 bedroom on the first floor (could be 3 BR)and a 3 BR apartment on the 2nd floor. 2nd floor features a nursery or office off the MBR. Second floor apartment was just painted. The apartments are in good condition, but the home needs roof & porch work & the boilers are very old. Perfect for an investor or owner occupant with fixup skills. Good upside potential. Available immediately.\"\r\n\r\nBuilt in 1925.  0.11 acres.  Full basement.  Aluminum siding.  No info on utilities.  One kitchen and both baths appear to have been updated.','The back porches look really bad. From the front it looks promising and wonderfully shady (the tree kind of shady), but it is pretty far from everything. Morton Street (the commuter rail stop it is closest to) is my last choice of all of available T stops to be near.','West of Washington.  **\n\nThis is very attractive to me.  The price certainly allows us to do our own renovations later.  The unit mix and square footage seems just about right.  The sideyards and front set back seem ideal to me and I like the mature trees.  I really do NOT like the back porches, and being on the T rather than the commuter rail would be preferable.','The lot size and trees appeal. And the interior looks reasonably attractive. Is it big enough for C&J? Downside is distance to T, of course. Also the unknown of just how much work it needs.','This could be a winner if it were closer to a T stop. At this price a new roof would not be a problem; can\'t tell about the porch. Like the look of it','The exterior is in good shape, just a little work needed.  It\'s in a densely residential part of town, with wide streets, a little quiet and on the outskirts of DOT, almost Mattapan.  Close to services on Blue Hill Ave.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010337737','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2600055',42.2887,-71.0884,1);
INSERT INTO properties VALUES (26,70272991,'n','Hartford St, 29','Uphams Corner','6/3/1','9/4/2',3200,'y','y','y','0.26 (UC)',1128484800,519999,'3/8: Under agreement per Sasha\r\n\r\n\"Quiet neighborhood. Great location. This extra large victorian 2 family actually has three units. 10 f00t ceilings, original crown moulding, beautiful hardwood floors, oversized rooms. This house was a gut rehab 5 years ago. Lots of great original details. 2nd floor bath is updated with jacuzzi tub. Move in condition. This is a must see! Bring offers, it won\'t last long!\"\r\n\r\nBuilt in 1900.  0.13 acres.  100 amps/natural gas.  New windows.  Full basement.  Shed.  Unit 2 includes attic 3/1/1.  Vinyl siding.','I\'ve revised my opinion a bit on this one. It certainly is somewhat tucked away, but if the commuter rail works for us it\'s easily close enough to Uphamss Corner, which includes services as well. Exterior is very appealing to me, size is good, and the views look nice - large porch/deck. Only question is work needed since the price is higher.','Great side yard space.  Despite the \"someone is moving\" clutter, it seems to have excellent woodwork detail.  If the systems were really fully updated, this is a good option.  I prefer the red line, but this close the commuter rail would be fine, for me.','I like this one a lot. If services are only a quarter mile away that\'s not a problem for me. The lot size, the views, the high ceilings appeal a lot. The T is  the big negative.','Five stars. Distance from T only problem I see.','I called to preview and I was told it was under agreement.  We\'ll keep our eye on it to see what % of list price it sells for.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010352405','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2613661',42.3163,-71.0731,1);
INSERT INTO properties VALUES (28,70292114,'n','Greenbriar St, 38','?','5/2/1','7/3/1',3007,'y','n','?','0.46 (S)',1131426000,464900,'3/10 update: Listing expired.\r\n\r\n\"Spacious Two-Family Philidelphia Style Home. Great for first time Home Buyers, large families, or Investors. Large Rooms, Hardwood floor, two floors per unit. Owners unit has new windows. First unit vacant and entire home will be deliverd vacant. Owner Willing To Entertain All Offers.\"\r\n\r\nBuilt in 1900.  0.07 acres.  Enclosed porch.  New windows.  100 amps/natural gas.  No photos of kitchen/bath.  Photos shown don\'t show any renovation.','The price of this one combined with T proximity makes it intriguing to me. I noticed the paneling as well. No idea what the kitchens are like, but the windows look large and nice. Also well situated between Fields Corner and Four Corners commercial areas. Potential Neg: right across from a school. Could be pos too, of course.','The shape and size seem nice.  Certainly the price allows for us to do some of the updates that are missing.  From the little we see, the rooms seem too small, even if the sf is high.  But is the paneling restricted to some sort of sunroom/enclosed porch?  The only non-paneled interior photo is much more attractive.','I like the look (outside), the size, the price, the T proximity, the\nfact that it\'s a Sasha-recommended street. It\'s hard to tell about the\ninterior even aside from the panelling. And the panelling may indicate a past renovation that made the rooms low-ceilinged etc. Being across from a school\ndoesn\'t seem a negative to me.','Crowded by surround, but could be a winner. Plastic furniture covers would seem to indicate the place was cared for. The dark paneling is a huge negative, but could be painted. Proximity to T a big plus.','Neighborhood: DOT Ctr/Franklin Park','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010383279','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2655768',42.2987,-71.0711,1);
INSERT INTO properties VALUES (30,70292605,'n','Clayton St, 44','?','4/2/1','6/3/1',3122,'?','n','n','0.35 (FC)',NULL,439000,'Deactivated 3/5:  No one liked it.\r\n\r\n\"Two family house close to U.Mass Boston. Updates include windows, floors, paint, kitchen. Call listing agent for faster response.\"\r\n\r\nBuilt in 1910.  Vinyl exterior.  ','In addition to what W said, looks like it has very few windows.','I really don\'t like this one.  Too few, too small windows.  Untended lawn.  Righ on top of the home next to it.  **  C & I would eliminate.','I agree with everyone\'s negatives on this.','Has no visual appeal; minimum number of rooms, but might be large.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010384224','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2657102',42.3028,-71.0562,1);
INSERT INTO properties VALUES (31,70292799,'n','Alexander St, 67','Uphams Corner','4/2/1','6/3/2',2696,'n','n','y','0.15 (UC)',1131512400,490000,'3/8: Under agreement per Sasha.  Closes 4/14\r\n\r\n\"Beautiful 3 yr old 2 family located on quiet side st. This property features an open floor plan owner\'s unit with hardwood flooring, gas fireplace, central air conditioning, 2 full baths and 3 bedrooms. The 1st floor rental unit consist of a living room, kitchen and 2 bedrooms. So, there is no need to look elsewhere when you can make this home!\" \r\n\r\nBuilt in 2003.  0.11 acres.  Aluminum siding.  Note: One row of houses between it and the commuter rail (not necessarily a negative).','Front is very appealing with lots of windows, interior is open and has potential. Price is right for us to do some work as well. And it is *really* right down the street from Uphams Corner.','New construction certainly has its advantages.  This one seems to have enough going for it to make up for the lack of history.  Great location, though commuter rail.  Excellent side yard between it and everything else.  pretty boring shape, but clean lines.  Fabulous open interior.  Lots of new windows for light.  But, 4/2/1 first floor (not clear the openness makes up for it) and no basement, at least accord to the listing.  Fireplace & central air bonus.','This looks square and boring, and the size of unit #1 is a negative. Close to transit but it\'s commuter rail. Sasha likes the street - positive. Price is also attractive.','No basement, if there really isn\'t one, is a huge negative. ','It was put under agreement yesterday.  Closes 4.14.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010385051','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2658310',42.3167,-71.0703,1);
INSERT INTO properties VALUES (32,70340935,'n','Church St, 84','?','5/2/1','8/4/1',3227,'n','y','?','0.38 (SH)',1133586000,499500,'3/21 : after visit to neighborhood, walk to T is just too industrial.  Deactivated in light of other options.\r\n\r\n3/4 update: New MLS number (old one was 70300581), but listing hasn\'t changed.  Photo is currently linked to old listing\r\n\r\n3/3 update: Listing expired\r\n\r\n\"Large two family duplex on quiet street close to shops and highway. 5yr old roof, about 90% of windows are new, 2nd unit is vacant, drive way can hold about 5 cars, nice back yard; possibility for condo conversion.\"\r\n\r\nBuilt in ~ 1900.  0.26 acres.  Largest lot in our list.  Heating oil/natural gas.  No info about electric.  2 car garage.  No basement.','I don\'t like the exterior either. It\'s .26 acres, btw, not 2.2, which is still the largest one on our list. Looking at the map, this is one where the walk to the T is going to be much longer than the crow-flies distance because of zig-zagging.','Because this is a duplex, not a stacked 2 family, both units have first floors.  I like this one better than most duplexes.','Weird. When you click on the picture you get what seems to be a completely different house. The picture here is pretty ugly. 2.2 acres?? That\'s huge. I\'d like to see interior pictures and have a better sense of what the outside really looks like too!','Upside down. Listing and table have rooms in Units reversed. Biggest lot I\'ve seen. Ugly','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010543935','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2682265',42.3082,-71.0593,1);
INSERT INTO properties VALUES (34,70303910,'n','Draper St, 118','Ronan Park','5/2/1','8/5/2',3316,'y','y','y','0.39 (FC)',1134363600,509900,'3/17 Update after viewing:  Pretty yard.  Big lot.  1% cash back.  On the low side of the street (other side has steep stairs to front door).  Biggest negatice is the hill necessary to get to and from T.  Must go up to Ronan Park and down again.  Not a priority right now.\r\n\r\n\"NOT A DRIVE BY!!!! Pride of ownership shows in this Dorchester 2 - Family Philadelphia duplex with 3316+ square ft. of living. All windows in 2nd unit replaced 5 years ago and 1st floor windows replaced 10 years ago. Updated kitchens and bathrooms, high ceilings, stain glass, formal dining & living rooms. Private parking with a GARAGE! Perfect for owner occupied or investors.\"\r\n\r\nBuilt in 1910.  0.10 acres.  Gas heat.  100 amps.  Partially finished basement.  Wood shingles.','The fence would have to go. Price is getting closer to us not wanting to have to renovate too much. I like the exterior shape a lot, but the interior might need too much help for the price point.','I actually really like the house\'s shape.  Can we make them take the mirrored closet doors with them?  If the updates are good and the kitchens can be opened to the rest of the living area, it may be worth the eight layers of primer to paint over some of the decor.','I see a lot of positives: the price, the location (another Sasha-recommended street, near T), the size and size of lot. Interior looks promising, despite the decor.','Location is appealing, not only with respect to the T stop. Would want to use a different interior decorator. Outside looks OK; fence questionable.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010415120','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2689418_10',42.305,-71.0654,1);
INSERT INTO properties VALUES (37,70307031,'n','Mountain Ave, 45*','?','4/2/1','7/3/1',2916,'y','n','y','0.28 (MS)',1135400400,497500,'3/20 update: Price increase from $492,500\r\n\r\n3/18 Deactivating commuter rail properties\r\n\r\n\"Fabulous home/assessed as 3 but being used as a 2-family. For owner occupant this bi-level unit is vacant and outstanding. 3rd floor level has vaulted ceiling, state of the art bath with jacuzzi/separate shower, a/c ,open floor plan for fab master bedroom. Additional room great for bedroom/office/den New deck & porch, replacement windows, gleaming hardwood floors, fenced yard and convenient location all add up to a great value for you! New systems, Easy to show-beautiful property!\"\r\n\r\nBuilt in 1905.  0.10 acres.  100amps.  Vinyl sided.  Natural gas.  Full basement.  New windows.','Description certainly sounds nice. Price is low enough to compensate for some shortcomings. Location is not good.','West of Washington  ***  Interior photos?  Again, I do like the idea of an attic Master bedroom suite.  It seems it could use more windows, but may still have good light as nothing is right next to it.  I prefer the red line, but this close to the commuter rail isn\'t bad.','Attractive outside. I have two concerns: the size of rooms in unit 1 since it\'s 4/2 - and the whole square footage isn\'t\nencouraging on this, and also whether it\'s close to services.','Don\'t like the look of the porches put on the front of the house. Not much to go on in terms of the interior.','In a dense residential neighborhood (Franklin Park/Dot Ctr), similar to Callender St. The exterior is in good shape.  I haven\'t seen inside yet.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010420308','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2696189',42.285,-71.0856,1);
INSERT INTO properties VALUES (39,70307372,'n','Folsom St, 14','Uphams Corner','5/2/1','7/4/2',4094,'y','n','y','0.13 (UC)',1135659600,495000,'3/18 Deactivating commuter rail properties\r\n\r\n3/17 Update after viewing: We really like this one and the street it is on and the neighborhood.  It has been painted purple and looks tidy.  Near a softball park.  The lot is narrow, but the hill allows light.  Back area with with deck.  Street parking only.  But, since near commuter rail, not red line, other options are preferred.  Not eliminated though.\r\n\r\n\"Recently renovated spacious two-family. Upper unit is expanded into finished attic with 2 extra bedrooms and full bath between. Gleaming hardwood floors. New eat-in sized kitchens with blonde oak cabinets, Corian counters & marble floors. Updated bathrooms. Just 2 blocks from public transportation. Offstreet parking. Rear decks. A must see.\"\r\n\r\nBuilt in 1905.  0.08 acres.  Claims recently renovated.  No details on utilities.  Basement of some kind.','This is right across the street from Hannon Playground, and the 2 blocks/.1 mile to Uphams Corner should cover services as well. Price is right, kitchens sound nice, and it\'s big.','This seems ideal in a lot of ways.  What C said, as well as unit layout, placement on block, etc.  Wish we had interior photos ...  If the reality matches the listing, this is something I would be tempted to try to move quickly on.','We need interior photos! Sounds almost too good to be true - why is it this inexpensive with the space, location and renovations? I like everything that\'s said about it and agree w C&J re positives.','All of the numbers are appealing. Visual verification needed; looks match description and numbers? ','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010421005','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2697202',42.3187,-71.0714,1);
INSERT INTO properties VALUES (40,70307702,'n','Ware St, 3','Jones Hill','7/5/1','3/1/1',2837,'y','n','?','0.49 (UC)',NULL,499000,'3/4/06 update: Listing canceled\r\n\r\n\"This GRAND Victorian home originally a single family is now a legal Two family with tons of details. First floor is bi-level unit that features two working wood burning fireplaces, hard wood floors, and many woodwork details thru out, high ceilings, plenty of natural light and so much more all at the base of JONES HILL. Views of the Pru & Hancock building from the third floor unit. These 20 pictures are a small taste of this Fabulous Jones Hill neighborhood home.\"\r\n\r\nBuilt in 1894.  Full walk out basement.  Wooden shingles.','','I am very curious as to the internal layout, and if redividing to a Philly style arrangement is possible.  Looking at the map, it feels like it is more than what I think of as a half mile to the T, but that is one of the only negs for me.',NULL,NULL,NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010421468','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2697726',42.3116,-71.0668,1);
INSERT INTO properties VALUES (41,70307714,'y','Lindsey St, 33','Melville Park','7/4/1','7/4/1',4018,'y','n','y','0.33 (FC)',1135746000,535000,'\"This well-maintained, large Philadelphia style two family home in the Melville Park area boasts two stories of generous living space and storage in each unit. Gas furnace, exterior clapboard painting and new roof were installed/completed within the past 2 years. Multiple walk-in closets provide abundant storage, as does the full walkout basement. Welcoming owners unit has been totally renovated. Paved driveway leads to 4-5 parking spaces behind the home. Rental unit can be delivered vacant.\"\r\n\r\nBuilt in 1885.  0.11 acres.  Wooden shingles.  Natural gas.  No electric details, but claims renovated and has breakers, not fuses.  Full walk-out, interior access basement with concrete floor (and sump pump).  New windows and storm doors.  Fenced yard.','Looks good, location is good. The paved back yard is a bummer. It is *very* close to the unit on the left in the above picture. The upper unit is more updated than the lower, but neither is close to top of the line. Kitchens and baths need work and most of the paint could use a touch up at least. The fences in front are chain link and kind of ugly. All that said, the layout is fantastic and it\'s very roomy, and I just love the foyer/landing area in the upper unit. Finally, the area is not as appealing to me as Kenwood/Moultrie (first choice, barely) or Ashmont.','It makes a truly great impression.  Tons of space with balanced Philly style units.  On a tenth of an acre, I want to understand if the parking is all paved.  At this price, we would need to be able to move in without having to do anything for years to come, but, by appearances and description, that seems possible.  Yay for storage throughout!  Everything looks updated, but not certain.  A third of a mile on a desirable street beats a tenth of a mile in a more frantic area.','One of \"Sasha\'s streets\", close to T, nice and big, philadelphia style,\nrecent renovation. Inside looks good.Lot size is good too. On the expensive end. Price reduction makes this more appealing, of course.','Appealing. Seems spacious; looks to be in good condition','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010421872','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2698487_1',42.298,-71.0678,1);
INSERT INTO properties VALUES (43,70314854,'n','Stanley St, 31','?','4/2/1','6/4/2',2520,'n','n','y','0.52 (UC)',1137128400,499900,'3/10 Deactivated based on size and reported internal boxiness.\r\n\r\n\"Just three years old, this magnificent Home needs nothing!!! Sitting on a Corner lot property with over 9000sqft, it features two units:- bottom unit is a two bedroom rental with an income of $1300/month, Upper unit has two floors of living with 4 large bedrooms, two full baths, nice large kitchen,gleaming hardwood floors, a cozy fireplace, high ceilings, recess lights, washer and dryer in both units, central A/C, 4 car driveway, landscaped lot, Large attic easy accesible for storage and more!!\"\r\n\r\nBuilt in 2002.  0.2 acres.  200 amps.  Clapboard.  Larger corner lot.','Small, over half a mile to the commuter rail and farther to subway. Given the other options doesn\'t make my list.','Positives = Corner large lot, all updated, clapboard, washer/dryer, hardwood floors, new construction, high ceilings  Negs = 4/2 1st fl, with this square footage and no basement, is small  ***  Given the distance from transit, this house may not be able to make up for being a new boring box with very odd paint/appliance choices.  But, could surprise me.','Large lot appeals, but square footage of house is low, so I wonder about the adequacy of first floor. Outside doesn\'t appeal.','This one is a puzzle. I\'m turned off by the shape, color of the building, but seems to have pleasant surroundings. One inside photo indicates an appealing openess that could work well.','I checked this one out today 3.9.  Still pretty close to Upham\'s corner.  Probably no more than a 10-12 minute walk.  Commercial/retail activity is thining out a little bit by the time you get as far as Bellvue.  The neighborhood is comprised of mostly 3F\'s nearly all with Direct TV dishes.  More foreign cars on the street than Mountain Ave and Callendar. It\'s halfway up a hill on an enormous lot.  It gets a ton of light inside -- endless windows, but it has little character.  Just as boxy inside.  Also unit 1 is signficantly smaller than unit 2, even more than the numbers suggest.  The two BRs in unit 1 are really tight.  Unit 2 is a duplex and has a great open living room. ','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010448591','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2715046',42.3109,-71.0688,1);
INSERT INTO properties VALUES (46,70316035,'n','Seldon St, 41*','?','6/2/1','7/3/1',2508,'y','n','y','0.38 (MS)',1137387600,489900,'3/16 -- Deactivated by consensus\r\n\r\n3/8: Price reduced from 495500\r\n\r\n\"Motivated Sellers. Bring All Offers! Move Right Into This 2 Family Home. 3 Bedroom Unit Is Ready For You To Occupy. First Floor In Lease To Provide Additional Income. Many Many Updates. Newer Heating Systems, First Floor Has Delead Certificate, Washer & Dryer Hook-ups In Pantry Both Units. Hardwood Floors, Replacement Windows, Porchs Done 2003. A Must See In A Fabulous Neighborhood. Minutes To Commuter Rail. Great Fenced In Yard, Off-street And Street Parking Available.\"\r\n\r\nBuilt in 1904.  0.11 acres.  Vinyl siding.  Circuit breakers, not fuses, but no amperage info.  Natural gas.  Full basement.','Interior really does look nice, but location is not ideal and the square footage is very low despite the high room count. And agree on the exterior - ugh.','West of Washington\n***\nThe entrance way on this is not inviting to me.  I wonder how much of that could change, as I attribute most of it to the overhang.  But, inside looks clean, airy, and light-filled.  Nice open spaces.','I agree with J. about interior - the exterior isn\'t very appealing. I\nwonder what the lot looks like: it\'s big but from the front it doesn\'t look like there\'s a lot of space around it. The size of the units seems good.','Looks as though neighbors are within spitting distance. Inside does look light. Outside would take getting used to.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010451255','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2718529',42.2815,-71.0781,1);
INSERT INTO properties VALUES (47,70317289,'n','Armandine St, 18*','Ashmont Hill','4/2/1','7/5/2',2902,'y','y','?','0.39 (A)',1137906000,525000,'3/26 After curbside visit with Sasha, it is not a priority.  Distance to transit and services, very, very narrow lot (there is no sideyard to the right side of the house, that driveway belongs to the house next to it.)\r\n\r\n3/1 Update price *increased* from 505K to 525K\r\n\r\n\"\"Spacious High-ceiling 2-family w/inlaw Apartment On Third Level. Owner Occupied On A Great Side Street Next To Ashmont Hill. Hardwood Floors On First Level; 2nd & 3rd Has Hardwood Floors Underneath Linoleum And Carpet. Partially Finished Basement. House Has Great Rental Income Potential. Also, Fenced Yard With/appealing Look On Outside. Easy Access To Public Transportation And All Major Routes And Shops. Huge Price Reduction. Bring Your Offers.\"\r\n\r\nBuilt in 1910.  0.13 acres.  No info at all about utilities, but looks like gas baseboard heat.  Fenced yard.  2 car garage.','Not ready to rule it out; total square footage looks about right if the first floor has enough. Given location and price it\'d have to be pretty near perfect otherwise though for me.','Right near the high school, one unit in from the corner.  What is Washington St like there?  Seemingly great yard and the garage is a bonus.  The photographer did not do the listing a good service.  Nervous about the appearance of the only bit of kitchen we get to see.  Ditto on the size of first unit concerns.  But no, not ruled out yet.','I like the lot size, the interior photos, the look of the surroundings. Questions about the size of first floor unit, and the location. And what\'s with the price increase?','Whether Unit 1 is adequate depends on room size and whether basement is really useable. A lot of positives:space around  house, location, condition of rooms inside. ',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010452259','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2720129',42.2844,-71.0721,1);
INSERT INTO properties VALUES (48,70322374,'n','Quincefield St, 10','Uphams Corner','6/2/1','7/4/2',3028,'y','n','?','0.12 (UC)',1138424400,549000,'3/18 Deactivating commuter rail properties\r\n\r\n\"Large Two Family Home With A Bi-level Owner\'s Unit, Finished Basement, Yard, Newer Windows, Updated Kitchens & Bathrooms, Hardwood Floors Throughout,front & Back Porches. Great Condition!\"\r\n\r\nBuilt in 1910.  0.07 acres.  Unclear if electric has been done.  Oil heat/hot water & natural gas hookup for range and washer/dryer (?).  Either vinyl or aluminum siding, they aren\'t sure (or both?).  ','The exterior of this one just does not appeal to me, from the pictures. Size and room count is good, as is Uphams Corner location. Price is high, however.','Hmm.   I like this exterior more than most and apparently more than C, which is ok, but should be noted.  Sideyards seem narrow though, and we have no interior photos, so ...  For the high end of the price range, saying \"updates\" and \"great condition\" is not enough.  I need more info.','Boy, do we need more pictures of this. I lean toward Jenn\'s view of exterior, but the negs seem to be the price and the size of the lot. Location and interior size are positive. ','If the fence is any indication, someone at least was concerned about how things looked. Way at upper end of price range. Seems roomy.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010461476','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2731025',42.3189,-71.0666,1);
INSERT INTO properties VALUES (49,70322860,'n','Westville St, 153','Fields Corner','4/2/1','7/3/1',2572,'y','n','?','0.24 (FC)',1138597200,438000,'3/19 Deactivated: low square footage comparatively, with nothing else making it distinctive.\r\n\r\n3/4 update: Price decrease from $451,500 to $438,000\r\n\r\n\"Vacant 2 Family home with 7 rooms, 3/4 bedrooms, 1 bath, fireplace. 2 of the bedrooms are located on the 3rd. level. Hardwood floors. Easy to show. Great location.\"\r\n\r\nBuild in 1910.  0.06 acres (smallest lot on our list).  Full basement.  Wood shingles.  No info on electric or gas.','Looks small, but cheap and near the subway. Unlikely that we can add total square footage cost effectively, though.','Listing narrative says it is a 3/4, which means 3 BR in first unit and 4 BR in second unit, but that doesn\'t match the data given numerically in the listing details.  Yay for fireplaces, but not enough without the rest of the package.  Given the price, I doubt it has been updated.  It is on .069 acres, but maybe is a corner lot?  Can\'t quite tell, but looks possible from photo.','I\'m concerned about the size of this, given 4/2 and the square footage. Hard to tell without interior photos, but the windows seem small and ceilings low.','Outside appearance a negative.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010462640','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2733360',42.3011,-71.0665,1);
INSERT INTO properties VALUES (50,70323721,'y','Moultrie St, 12','Melville Park','7/4/1','7/4/1',3170,'y','y','?','0.16 (S)',1138597200,569900,'3/18 update: Under agreement\r\n\r\n3/17 update after exterior viewing: exterior photography is deceptive.  The front yard is non-existent and the porch is only decorative.  Disappointing from our hopes, but, not dashing.  There does appear to be a larger rear yard.  Still want to see interior.  Foolish street arrangement with one way in both directions from the connecting road.\r\n\r\n\"Grand is the word for this 14 room, 2 family home. Each unit includes 4 bedrooms with walk in closets, a formal diningroom, livingroom, eat in kitchen with butlers pantry and 1 bath, and beautiful winding staircases taking you to the next level. This 5000sqft lot with large back yard, deck for entertaining, partially finished walk out basement and its unique floor plan make this home a must see.\"\r\n\r\nBuilt in 1900.  0.11 acres.  Does not state amperage, but has circuit breakers, not fuses.  Partially finished walk-out basement.  2 car garage.  Insulated windows.  Natural gas.  Rear deck.','Size is good, interior and exterior look very promising, and location is good. With our adjusted price range I still feel it couldn\'t need major kitchen/bath work, but it\'s very appealing.','Just beautiful from what we see, but why don\'t we see either kitchens or baths?  If they are not updated, even if the price comes down it is not worth it.  But, from what we do see, I\'m certainly smitten.','Smitten\'s the word. I don\'t know what happened to my original  comment on this - probably failed to save it myself. I loved it on first sight and the interior photos are enormously appealing. I agree with all of the rest of you about price.','Ditto Chuck','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010463689','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2734348',42.2919,-71.068,1);
INSERT INTO properties VALUES (52,70325558,'y','Van Winkle St, 80','Ashmont Hill','4/2/1','6/2/1',3483,'y','n','y','0.18 (A)',1138942800,509900,'4/1:  Too cramped and too much work to do.  Like the neighborhood and the style, but worried about the time and money black hole.\r\n\r\n3/26 update: saw inside -- many good aspects -- details to follow.\r\n\r\n3/17 update after exterior viewing: Big back yard with mature trees.  The house to the left is set back, keeping the sid windows clear.  Very very easy walk to T, but still secluded St divided by train\'s right of way.  Not much repairs would be needed for the price.  How does the square footage jibe with the room count?\r\n\r\n\"Columns grace the entry way to this delightful 1800\'s 2 family victorian in highly desirable \"Carruth Street area\". This home boasts wood floors, high ceilings and original diamond pattern leaded windows. Owners have invested over $35,000.00 worth of updates including new kitchen w/ stainless steel appliances in owner\'s unit, Hampton Bay fans and new electrical throughout. Close proximity to public transportation and expressway. Don\'t miss this opportunity!\"\r\n\r\nBuilt in 1875.  0.17 acres.  Vinyl sided.  Certified historic.  Pretty large lot.  Natural gas.  Electric is \"new,\" but current amperage is unstated.','This is *so* attractive inside. But the 2nd unit is on the small side due to the  slope and how much the 3rd floor is not useable for adult space. First floor unit is spacious and light. Back yard is great and huge. Especially after the second viewing I\'ve had lots of pseudo-daydreams about how we could rearrange some of the 2nd/3rd floor space. Not sure how realistic any of that is. Another possibility is another building in the back yard.','This house is \"upside down\" from what we are looking for and the smaller unit is a 4/2/1, but for now I want to keep it on the list.  The square footage is very large, it is very close to Ashmont T.  I love the historic details and certification, if all the renovations we want have already been done.  It does not seem so expensive for all that.  So, ideally, I would like to see it before ruling it out.','I agree with Jenn on the positive on this and also that it\'s hard to judge without seeing. ','Historic certification is interesting; could be a problem.','Tons of character in a hood surrounded by beautifully restored single families.  Very cool turret room.  Unit 2 (2nd floor) is bigger, but not at the expense of Unit 1 bedrooms. Good sized lot.  I would encourage us to see this together. ','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010477497','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2739140_1',42.2834,-71.0613,1);
INSERT INTO properties VALUES (53,70327558,'n','Claybourne St, 20','?','5/3/1','8/6/2',2568,'y','n','y','0.51 (S)',NULL,524900,'3/4/06 update: Under agreement\r\n\r\n\"Incredible 2 family. Gut-rehabbed in 2005. All new everything. New roof, siding, floors, walls, ceilings, plumbing, electric, heating etc etc etc... Truly one of a kind. 8 room/6 bedroom/2 bath duplex leased for $2300.00/month. Plus 5 room/3 bedroom leased for $1560.00. Perfect for 1st time homebuyer/ owner-occupant. This is as low-maintenance as it comes.\"\r\n\r\nBuilt in 1900.  Fenced yard.  200 amps.  Natural Gas.  Vinyl. ',NULL,NULL,NULL,NULL,NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010522029','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2743147',42.299,-71.0721,1);
INSERT INTO properties VALUES (54,70328070,'n','Edison Grn, 10','?','4/2/1','8/4/1',2777,'y','n','n','0.29 (JFK)',1139374800,469000,'3/16 -- Deactivated by consensus\r\n\r\n3/8 -- Listing renewed.  Price reduced from $489,000\r\n\r\n3/1 Update -- Under Agreement\r\n\r\n\"Unique 2 family. Unit one has 1 level, unit 2 has 2 levels. New windows and freshly paved driveway. Minutes to T.\"\r\n\r\nBuilt in 1905.  0.08 acres.  No utilities info.  Basement, but type not specified.','T stop is across the highway (should be a walkway, but ...) and there looks to be little services around - Uphams Corner is closest. This doesn\'t have a lot going for it to me.','Do we think it failed inspection?  Obviously, no way of knowing, but if it was just the buyer backing out, why the price reduction?  It looks a little dreary, but maybe that is the light off the vinyl siding.  The walk to the T would cross Dot Ave and go under the highway.  The price is fine for having to redo the kitchens, but this does not have so many advantages that I would want to invest my energy.','Unenthusiastic. The outside isn\'t too bad, but that one inside photo of bay window looking right at walls of house next door is pretty dreary. I agree with all expressed reservations.','Edison Green has a great ring to it. Unit 1 rooms a minimum; size and layout would determine suitability. Seems rather hemmed in. Bounded on two sides by what looks like major arteries. Difficult walking?',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010523267','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2745107',42.319,-71.0573,1);
INSERT INTO properties VALUES (55,70328103,'n','Quincy St, 50','?','4/2/1','9/6/1',2735,'y','n','n','0.60 (UC)',1139374800,489900,'3/12 Deactivated: comparative distance from  and need for renovations.\r\n\r\n\"Very well maintained two family, 1st flr unit features 4rms, 2Bdrms, hdwd flrs, high ceilings, fire place. 2nd Unit features 2 levels 9rms, 6bdrms, perfect for a big fam. Hdwd flrs. Parking for 2 cars, great yard. Very motivated seller\"\r\n\r\nBuilt in 1900.  0.08 acres.  New windows.  Lead certs.  *60 amp service*  Wooden shingles.  Natural gas.','Total size is low and it\'s over half a mile from the commuter rail - and not really towards anything else. Looks like the front yard is the parking, also - unattractive from street.','Note that the first photo is NOT the front of the house.  The second photo shows the front entrance, which is on the left side of the side of the house you are looking at.  It looks like there is a little walking path between a number of houses that have their entrances facing each other.  ***  Pretty and airy interior.  I feel the aesthetic is in line with the price.  The size of unit 1 could be problematic, given the square footage, but I wonder if they have done the same thing as 9 Draper, counting the attic\'s rooms, but not its area?  Both kitchens see workable, etc.  The biggest, probably insurmountable negative for me is the distance from the T and services.','Interior photos more attractive than exterior led me to expect, but\nwhere\'s the great yard they mention? Looks like the car\'s parked on it.\nSize of the first unit is a concern, also the 60 amp service.','Do not like appearance; perhaps because it seems to be sideways to the street. Electrical a huge problem. Inside looks nice, but leaves me wary.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010523306','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2745146',42.3154,-71.0799,1);
INSERT INTO properties VALUES (56,70342255,'n','Havelock St, 15*','?','7/4/1','7/4/1',2837,'y','n','y','0.48 (MS)',1139547600,519900,'3/18 Deactivating commuter rail properties\r\n\r\n3/6: Property reactivated with new MLS number.  The old number is 70329731.  No apparent changes.\r\n\r\n3/4: Listing canceled\r\n\r\n\"Gracious and spacious recently renovated Philadelphia style 2 family home. Conveniently located near shopping, transportation, and school. This beautiful home features: living room, formal dining room, 4 good size bedrooms on each floor w/ ample closets, newer kitchens, bathrooms, vinyl windows, new 100Amps electrical service w/separate house meter, fresh paint, gleaming hardwood floors, and lead paint free . Great for condos conversion or owner occupant!\"\r\n\r\nBuilt in 1900.  0.09 acres.  100 amps (2 meters).  Natural gas.  Lead paint certs.  Aluminum siding.  New windows.  Full, partially finished basement.','I like what Sasha said about Blue Hill Ave., which this is near. However, otherwise 33 Lindsey has it well beat for location, as do some other less expensive properties. With only this one photo I\'m reserving judgement on this one in most ways.','On paper, it seems to have what we need.  I wonder how much of the negative impression of the exterior is either the photography or purely surface related?  I find it interesting how similar the shape is to 33 Lindsey, but how much more I like that one.  The odd front porch could easily go.  Ultimately, though, the distance for the price is the factor that is hard for me to figure out, compared to other options','I\'m last in on this, and agree with all that\'s been said. Without interior photos it\'s hard to work up enthusiasm. 33 Lindsey also has over 1,000 more sq.ft. - bigger rooms? I understand your \"small is beautiful/ecologically sound\" stance, Jenn, and agree to an extent: what doesn\'t appeal are a lot of small cut-up rooms, though.','Jenn\'s comment rang the bell; similar to 33 Lindsey and also 12 Moultrie but third floor different. This one has the front entrances framed with down spouts- Ugly - but something that could possibly be changed. Question location; not one of Sasha\'s prime streets, and nothing known about interior. May need a visit. ',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010546320','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2777057',42.2863,-71.0913,1);
INSERT INTO properties VALUES (57,70331005,'n','Blue Hill Ave, 216','?','5/3/1','6/3/1',3000,'y','n','y','0.47 (UC)',1139806800,520000,'3/17: Deactivated by consensus after outside view.  Lovely, lovely, intriguing home with lovely renovations.  But, far from commuter rail and the street is hard to park on and there are better options, including things on the Red Line.\r\n\r\n\"This home has been gutted down to the studs and restored with all NEW ELECTRICAL WIRING, NEW PLUMBING, WALLS BATHROOMS,KITCHENS, HEATING SYSTEMS and so much more. Views of the Pru and City sky line from the second floor.\"\r\n\r\nBuilt in 1900.  0.12 acres.  Full finished walk-out basement.  100 amps.  Natural gas.  Wooden shingles.  New windows.','I do like the exterior on this one a lot. Potential neg: Blue Hill Ave. is a pretty big street. Not sure if it\'s Broadway-big or McGrath Highway big. 3rd floor vinyl/linoleum is odd. Price is high to be far from transit, but size looks doable and it has the updates.','I really like this one, including the exterior appearance.  I wish it was just a bit closer to transit, but the shape, style, livability, square footage, etc.  Great front porch, open rooms, original lintels and window frames and other wood.  I don\'t know Blue Hill Ave either; is the area around it green park, or industry?  Sattellite is unclear.','The outside is kind of funny looking, but the interior looks big and light, very appealing. Lot size and fenced yard a plus. Don\'t know enough about Blue Hill Ave to judge that issue.','I think this one deserves a seious visit. Don\'t know the street so that could be a negative.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010527001','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2750375',42.3171,-71.0779,1);
INSERT INTO properties VALUES (59,70332716,'n','Lonsdale St, 12','Ashmont','4/2/1','8/5/1',3242,'y','n','n','0.27 (S)',1140066000,529900,'3/16 -- Deactivated by consensus\r\n\r\n3/9: Price reduced from $545,000\r\n\r\n\"Well kept home on convenient side street close to Ashmont and Shawmut stations on Red Line. Just 3 blocks to Peabody Square. Plenty of storage. Living on 3 levels. Sale is contingent on seller finding suitable housing. Workbench in basement will remain. Street is one way and enters from Adams St. Parking onstreet only. Yard is fenced.Siding, roof, windows and furnaces all less than 10 years.\"\r\n\r\nBuilt in 1907.  0.08 acres.  Full walk out basement.  New windows.  Vinyl siding.  100 amps/natural gas, but kitchens/baths not done, wood paneling in all rooms.','The last 3 inside pictures give me some hope, but otherwise, what Sandy said. Total square footage is high enough depending on what 1st floor gets.','One of a handful east of Dot Ave.  Important that traffic is one way onto Dot, rather than from it.  Still, for the price, it is too crowded by the other buildings, unit 1 is too small, and the interior is ugly in a way that would take a lot of work to remediate.','Not attractive outside, and 4/2 unit is small. Pictures of inside don\'t thrill me either. location is good.','redone inside during the panelling period. Very close to Dorchester Ave.; probably within the Business District boundary shown on Ashmont/Peabody Square map.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010529824','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2754123',42.2902,-71.0625,1);
INSERT INTO properties VALUES (60,70333699,'n','Ashmont St, 414','Adams Village','6/3/1','6/3/1',2812,'y','n','y','0.49 (A)',1140325200,529900,'3/17: Deactivated by consensus after outside view.  Incredibly narrow lot and far from T, though nicely in Adams Village.  Better options.\r\n\r\n\"Spacious 2-family in sought after Adams Village. Each unit has 6 rms, 3 bedrooms, 1 bath, hardwood flrs, updated kitchen and bath, period woodwork. Shared driveway and private fenced-in yard with potential for off-street parking. Front and back porches. Convenient to all.\"\r\n\r\nBuilt in 1920.  0.13 acres.  Wood shingles.  100 amps.  Natural gas.  Full basement.','The interior will determine my take on this one; price is too high for me to see renovations as worth it given that it\'s not *right* on transit.','6/3/1 could be fine, plus there is potential for some basement storage.  The square footage seems to indicate it would be about 250 sf more than we have now.','Seems like a good location and it looks reasonably attractive from outside. Big lot, too. But is the size of the second unit big enough?','Satellite seems to show empty space in back of house??? Agree; need information about inside.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010531476','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2756739',42.2882,-71.0561,1);
INSERT INTO properties VALUES (61,70334867,'n','Fuller St, 246*','?','5/2/1','5/3/1',2216,'y','y','y','0.41 (MS)',NULL,499000,'Deactivated 3/6: Just too small and far from everything.\r\n\r\n\"Rare find brick 2 fam with new gas heating and hot water systems...........must see. AN ATTIC FOR POSSIBLE EXPANSION\"\r\n\r\nBuilt in 1920.  ','Total square footage is _tiny_ and location is not very good.','West of Washington','I like its being brick, plus the size of the windows,and the lot size. Neg is the size of the second unit - don\'t know if attic expansion is enough to balance that.','Like exterior appearence a lot, but probably too many other negatives.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010533493','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2759359',42.2805,-71.0774,1);
INSERT INTO properties VALUES (62,70335162,'n','Draper St, 9','Fields Corner','5/2/1','8/4/2',2318,'y','n','?','0.14 (FC)',1140584400,495000,'3/17: Deactivated by consensus after outside view.  Deceptive and derelict.\r\n\r\n\"Great two family home Fields Corner Area. Must SEE!! All replacement vinyl windows, Shiny Oak hardwood floors throughout. Ceramic tiles On bathroom floors, vinyl floors in kitchen.  Beautifully and professionally Finished attic with oak floors, full bathroom and computer area. Deleaded certificates in hand. Vinyl siding . Bring pre- approval certificates. Move right in-ready for new owner.\"\r\n\r\nBuilt in 1905.  0.09 acres.  Lead certs.  Vinyl siding.  Full, interior access basement.  Porches.  Natural gas. New windows and storm doors.','The BRA maps really make it clear just how great the location is - blocks to a park, T, several schools, and both Dorchester Ave. and Geneva St. which are main streets with commercial services. Price is right but the square footage is very low for the room counts.','The shape of the house is a colonial form I can recognize, even with the annoying (!) photo tricks.  Ditto Chuck on location.  If the interior lives up to its billing, considering the price, this could be the one.  ***   As re: W and C\'s concern re room:sf ratio --  I think the sellers are cheating on the room totals, but not the square footage.  They are not supposed to count the finished attic for either.  The 8/4/2 on the Remax listing is clearer that it covers both levels of unit 2, with 3 of the rooms and a bathroom in the attic.  The first and second floor are essentially identical 5/2/1\'s.  But, I am guessing, they did not count attic square footage in the house\'s total.  Maybe this can work to our advantage, like a mislisted ebay item?  :)','Great location. Despite the difficulty of seeing, it looks and sounds attractive.','Can photos be obtained that were not taken through a kaleidascope? Though it\'s Unit 1 has 5 rooms, almost every listing the has 4 rooms in Unit 1 has more Sq. Ft. ???','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010534255','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2760520',42.3018,-71.0631,1);
INSERT INTO properties VALUES (63,70296923,'y','Moultrie St, 24','Melville Park','4/2/1','8/5/1',2828,'y','n','n','0.22 (S)',1132549200,509000,'3/26 update: after touring the interior, C & J are eliminating this property as needing far too much work.  The square footage may be ok, but the rooms are jury-rigged and the larger unit has a ton of tiny spaces.  Kitchens are inadequate.  Electricity is old.  Both bathrooms are atrocious, with the first floor one appearing to be a converted closet, with its toilet tank parralel to the tub, such that someone sitting on the toilet seat would have their back to a third of the tub.\r\n\r\n3/18 update: OMG!!  Listing has been reactivated again.  With a price drop of $20,000, from $529,000.\r\n\r\n3/13 Update:  J is giving up, as realtor.com no longer recognizes the MLS #.\r\n\r\n3/6 Update: Per Sasha, the sellers have decided not to move.  Coldwell listing says \"canceled\" (again!); ReMax says \"temporarily withdrawn.\"  J decided to keep this active til the situation clarifies, as it is such a strong candidate.\r\n\r\n\"Well Maintained 2 Family Home On Quiet Street. Unit 1 Has 2 Bedrooms And 1 Full Bath. Unit 2 Has 5 Bedrooms With 2 Level Living. New Windows And Hardwood Thru-out. Private Parking For 4 Cars. 5 Minutes Walk To Shawmut Station. Will Deliver Both Units Vacant.\"\r\n\r\nBuilt in 1900.  0.10 acres.  Corner lot, fenced yard, natural gas.  *60 amps*  Vinyl sided.','This is an easy walk to Codman Square, as well as everything J said.','This place pushes all my buttons in happy ways.  I have no idea how I would react in person, but from what I can see, it feels ideal.  Shape, woordwork, corner lot in widely spaced residential neighborhood and  a very easy walk to the T.  I recognize the 4/2/1 first floor is hard to picture being big enough, but I don\'t want to rule those places out without seeing how much space each really has.','I agree with J. I like everything about it except the numbers for the\nfirst floor, but that might be deceptive. ','Will need to be re-wired. Definetly needs to have a serious look. Closer to Washington than 12 is (the pink one)','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010391878','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2667720',42.2915,-71.0692,1);
INSERT INTO properties VALUES (65,70339378,'n','Dorchester Ave, 1623','Shawmut','4/2/1+','6/3/1',2391,'y','y','y','0.23 (S)',1141189200,554900,'3/17 3/17: Deactivated by consensus after outside view: busy street, small, paved yard, even though nice interior\r\n\r\n\"Updated Multi Family Conveniently Located On Dorchester Ave. With Walking Distance To Trains And All Amenities. Two Spaceious Units With Open Floor Living Room And Kitchen Area. All Newly Finished Hardwood Floors. This Also Has An Additional Finished Basement With 3 Rooms, 2 Bed Rooms And 1 Full Bath * Great For In-law Apartment * Or * Could Have Additional Rental Income. ** Detached Garage ** Off Street Parking For 5 Cars ** Vacant *\"\r\n\r\nBuilt in 1915.  0.11 acres.  100 amps/natural gas.  Wood shingles.  Full finished 3/2/1 walk out basement.\r\n','The interior is really attractive to me, but the price doesn\'t leave room to fix the front yard. Total size is small as well.','This is 4/2/1 for unit 1, expensive, has a horrid paved front yard, and only 2391 sf.  BUT there is a 3/2/1 inlaw in the basement not included in the other totals, it has been renovated, and it is right on Dot Ave, near Shawmut.  Worth keeping for now, I think.  Does anyone know the word for a ceiling like this with the cross-beams present?  I forget.','One or two of the interior pictures make me think this isn\'t an immediate no, but I\'m pretty dubious. Exterior doesn\'t appeal, ceilings look mostly low, windows small, and it\'s expensive.','Amazingly mixed feelings about this one. Dislike intensely the paved front \"yard\", but some of the interior views are appealing.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010541886','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2771123_6',42.2952,-71.0618,1);
INSERT INTO properties VALUES (66,70340848,'n','Downer Ave, 22','Jones Hill','7/5/1','5/2/1',2850,'y','y','n','0.38 (SH)',1141362000,449900,'3/17: Deactivated by consensus after outside view.  Nothing compelling whatsoever, and on very steep hill.\r\n\r\n3/5 update:  Price raised from $425,00 to $449,900 one day after the MLS listing was created.\r\n\r\nJ strongly believes this was on the market last year, and is now being relisted.  No access to the old listing.\r\n\r\n\"Large Two Family In Jones Hill Area. Sellers Are Willing To Consider All Reasonable Offers. House Is In Need Of Minor To Moderate Cosmetic Work. Kitchens And Baths Are Updated. High Ceilings And Hardwood Floors. Some Tlc Will Bring Out The Beauty Of This Home. Close To Various Amenities. House Can Be Delivered Vacant. Great For Owner Or Investor. Show & Sell\"\r\n\r\nBuilt in 1900.  0.08 acres.  Wood shingle exterior.  *60 amps*.  Natural gas. Full basement.','Price is right (though was better) to deal with any interior issues and rewiring, but location does not appeal to me as much as either Uphams Corner or the southern 3 red line stops.','Note that the room distribution is inverted from what we are hoping for.  Might be able to rearrange.  I am not sure the amount of renovations needed would be worth it, but won\'t be able to tell from the listing alone.  Jenn also notes that Walt is a funny man.','It sounds as if it\'s worth a look from what\'s said about interior details. Lack of pictures makes it hard to tell. And I agree with J. and W. about the negatives. ','Would have to be re-wired. Room distribution is a downer.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010542859','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2772459',42.3113,-71.0608,1);
INSERT INTO properties VALUES (69,70335760,'y','Whitten St, 10','Shawmut','5/3/1','7/4/1',2600,'y','y','y','0.20 (S)',1140670800,499000,'\"Great condition with many original details, paved driveway with one car garage. Hardwood floors throughout and very nice wood shingles siding and new paint interior and exterior. All systems are updated. Very good location! Convenient to Boston and shopping malls etc...\"\r\n\r\nBuilt in 1920.  0.08 acres.  Full basement.  Wood shingles.  No info on utilities.','Price and location are good, size looks okay. Outside looks promising, need to see interior.','After visiting the neighborhood, this looks more promising.  Not enough info to say anything else not said already.  I find all these brown and mustard yellow colonials a bit depressing, but I can get over that and down the road we could change it.','Really hard to tell without pictures.\nExterior is reasonably attractive, and the size of units appropriate. ','Lots to like about this one. Seems to be just off the Codman Square map, but could be close to Business District area, which is not necessarily a negative. The garage is a rarity and a big plus.','','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010535518','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2761951',42.293,-71.0617,1);
INSERT INTO properties VALUES (70,70341037,'n','West Cottage St, 77','?','3/1/1','5/3/1',2552,'y','n','y','0.40 (UC)',1141534800,515000,'3/6 Deactivated: Too far from transit, too small, no one liked it.\r\n\r\n\"Charming two-family home on Dorchester/Roxbury line with many updates. First floor has 3 rooms and 1 bedroom that features an open layout, newer paint, floors and kitchen. This is one of the bigger one-bedrooms you will see and it brings in $1,100 per month (comparable to a two-bedroom rent). Second floor is bi-level with three bedrooms. Master bedroom has two closets (one a walk-in). Off-street parking for as much as three cars. 2001 renovatins include vinyl siding, baths and kitchens.\"\r\n\r\nBuilt in 1890.  Appears to have updated kitchens.','Both units are quite small and location is okay but not great. And one of the units has a VERY yellow kitchen wall. Eek! Price is high for not being ideal.','I genuinely like the exterior appearance, but have nothing else positive to say.','I know they say it\'s a big one-bedroom, and has an open layout, but it\'s hard to imagine three rooms working. ','Apparently some studs had to be left when it was converted to an \"open\" look, which rather defeats what it was trying to accomplish.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010543918','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2773724',42.3207,-71.0761,1);
INSERT INTO properties VALUES (74,70344399,'n','Fossdale Road, 19','Ashmont','6/3/1','7/4/2',2906,'y','y','n','0.26 (A)',1141966800,599000,'3/17 update after exterior viewing:  Photo washed out b/c of paint color, but good detail.  Very steep hill.  Seems big with a set of decks.  Roof and eves need repair?  For price, much happier with Melville properties.  Not a priority right now.\r\n\r\n\"Oversized two family in great area. Large rooms, nice detail, great decks, garage. Owner\'s unit 2 levels w/2 full baths. Nice House! Delivered Vacant\"\r\n\r\nBuilt in 1930.  0.12 acres.  Full basement (Remax says both \"full\" and \"no\"), porch, & deck.  Circuit breakers, not fuses, but no amperage info.  Natural gas.  Newer windows.  Wooden shingles.','I feel neutral about the outside from this particular picture. It looks generally nice to me, but I\'m not sure it\'s top-of-the-price-range nice, especially since there are other options this close to transit.','The interior is dated for the price, without character and exposed woodwork to make up for it.  Not a bad option, but there are a lot that are better.','I agree with C. and W. Outside is a little bland, inside less attractive than some others, like 12 Moultrie. It would have to surprise me to make me enthusiastic.','I also feel neutral about outside. Bedrooms could be small, indicated by one of the photos. Neighboehood could be a big plus, as is the garage and size of property.','This is in the Ashmont Park neighborhood. As with Van Winkle, this hood consists mainly of stately single families. All the conveniences of Adams and Ashmont Streets. I believe the exterior has a lot of potential. There is actually a lot of detail that is getting lost in the photo and the white on grey paint job. Most of the homes on the street have been painted vibrant, contrasting colors, much like the houses on Centre St in JP. The interior feels very spacious and sprawling, with beautiful moldings and floors. Each unit has original china built-ins in the dining room. There are also three different stairwells giving you the flexibility to configure the units whichever way you want. It could easily be a 3F since there is already a bathroom on the top floor of the second unit. The backyard is a good size and there is a separate garage/carriage house. The kitchens are older but functional providing the opportunity for a project and value appreciation. ','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010549099','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2780689',42.2852,-71.0593,1);
INSERT INTO properties VALUES (75,70344165,'n','Whitten St, 17','Shawmut','5/2/1','9/4/2',2583,'y','y','y','0.25 (S)',1141966800,540000,'3/18 update: Listing canceled.\r\n\r\n\"Nice House On Nice Tree Lined Street, Owner\'s Unit On 2 Levels, 3rd Floor Features Skylights, Huge Bath And 2 Large Bedrooms, Loads Of Closet Space. House To Be Delivered Vacant.\"\r\n\r\nBuilt in 1925.  0.077 acres.  Full basement.  Single car garage.  100 amps/natural gas.  Porch.  Wooden shingles.','Size is a little small; without interior pictures it\'s hard to tell. Description sounds nice though (skylights!) and the exterior looks good to me.','I like the elbow room between its neighbors.  Looks well-cared for.  Unit distribution is ok, but overall sf is small, unless they are not counting attic.  Distance and price are good, especially for being renovated, at least electrically.  There seems to be space for a nice back yard.  ','I like the look and shape of the outside. Again, we need pictures of the inside to tell. Square footage is a concern, though, and the lot\'s on the small size too.','Ditto Charles. 100 amps and gas a plus, as is a garage. Could be mirror image of 10 Whitten St. Small property.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm;jsessionid=ESQIk04muEn8tgg2JcwFvjVVJH2DoXMbxPDernFEZKAQbmCZjQL3!-1176883755!-1408231912!80!443?id=1010549075','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2780665',42.2928,-71.0609,1);
INSERT INTO properties VALUES (77,70318482,'n','Ashmont St, 37','Ashmont Hill','5/3/1','9/5/2',3833,'y','n','?','0.57 (A)',NULL,559000,'3/17: Deactivated by consensus after outside view.  Nothing special for the distance and the price.  Hill.\r\n\r\n\"Large Three Family On Ashmont Hill! Solid 5/3, 5/3, 4/2. Great Chance To Owner Occupy Or The Investor Looking To Do A Condo Conversion. Rear Porches, Private Yard And Off Street Parking Are Just A Few Amenities This Home Has To Offer. Full Walk Out Basement With Double Entrances And Lots Of Charm And Woodwork Thru-out. Not A Drive By, A Must See Inside To Realize All Its Potential And Features. Don\'t Miss Out Call For Your Showing Today!\"\r\n\r\nBuilt in 1920.  0.09 acres.  Full walk out basement.  ','If what they say about the inside is accurate that could boost this for me, but with no pictures... the outside is okay but not really appealing to me, and it\'s over half a mile to the T.','Nicer things, the same shape and approx size, closer to bustle and cheaper than this.  Does not look crisp, but don\'t know if that is the photographer.  Not a priority for me.','I\'d have to see the inside. The outside seems similar to but not as attractive as several others that have better locations and attractive interiors.','Cannot tell much from this information. Seems spacious inside, not much room outside. Is there a door to access the 2nd floor front porch? Two different maps have this property at two different places.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010454304','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2722592',42.2883,-71.0544,1);
INSERT INTO properties VALUES (79,70316016,'y','Kenwood St, 25','Melville Park','6/3/1.5','9/6/2',4064,'y','y','y','0.27 (S)',1137301200,569900,'\"Huge Two Family Duplex Located Within The Melville Park Section Of Dorchester. This Property Offers Over 4000 Sq Ft Of Living Space, Grand Foyers, Formal Living And Dining Rooms, Hardwood Floors, 9 Bedrooms, 3.5 Baths, Off St. Parking And A 1 Car Garage.\"\r\n\r\nBuilt in 1910.  0.14 acres.  Stone/Stucco exterior with slate roof.  100 amps/natural gas.  New windows.  Full basement.','There are great hardwood floors under many of the carpets. However, we have been leaning away from having 3 living levels per unit which this one provides. I can see the great bones under the left hand (larger) unit; the smaller unit is not as well kept and seemed dark.','Yay for 2 bathrooms and not having to rearrage/renovate an attic inlaw.  I like the pantry and, though the rooms are very dated/not my style, they would certainly be liveable for a time and look well-cared for.  Big bonus on the garage.  It is a nice in between distance to the T.  I would like to prioritize this one.','I agree with C & W\'s comments. It seems huge, and some of the inside space is very attractive. The extra half bath is a plus. I like the size of the lot, and the exterior is pleasant. The drop ceilings are a neg. for me.','I like the looks of this one; would feel good about living here as I\napproach the house coming back from the T. A drop ceiling in two of the\nrooms pictured a minus; otherwise like inside appearance. Rooms look\nspacious. Hot water heat a plus.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010449888','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2716884',42.2918,-71.0704,1);
INSERT INTO properties VALUES (80,70334219,'n','Kenwood St, 78','Melville Park','5/2/1','8/4/2',3751,'y','n','?','0.13 (S)',1140238800,599000,'3/17 update after exterior viewing: In disrepair and poor windows, especially when price is compared to other options in the immediate neighborhood.  But, if other options fall through, perhaps still worth looking more closely.  Not a priority right now.\r\n\r\n\"Great Location Melville Park Area-3 Unit 2fam Used As A 3fam Fireplaces Nice Condicion Good Rents Good For Owner Occupied,investment Or Condos Nice And Quiet St.set Among Very Beautiful And Grand Homes In The Neighborhood\"\r\n\r\nBuilt in 1895.  0.14 acres.  Full basement.  Natural gas/no electric info.  Wooden shingles.','Great location. No inside pictures to justify the price. Why the quick resale?','I like the look and the neighborhood.  I think the front door faces out, even though the bay windows are to the yard, and I don\'t mind that.  I very much like the room division, feel it suits our needs.  If it it not already updated, the price is too high.  If it is, it would be worth looking at more closely.','We need pictures. The location and size are positives, as is the size of the lot. But it would have to be gorgeous inside at this price.','Inviting outside appearance; inside a mystery. numbers indicate roominess. Why are taxes so low?',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010533550','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2759416',42.2928,-71.0681,1);
INSERT INTO properties VALUES (81,70333920,'n','Ruthven St, 3','?','6/4/1','10/6/2',4002,'y','n','?','0.58 (SB)',NULL,599000,'3/17: Deactivated by consensus.  Connected to other buildings, too expensive for the distance from the Orange line.\r\n\r\n\"Beautiful renovated 3 family with good rents in convenient location close to Egleston square and public transportation.\"\r\n\r\nBuilt in 1920.  0.09 acres.  Full basement.  100 amps/natural gas.  *Forced Hot Air*  New windows on some floors.','The outside of this really appeals to me, but I agree with Walt that it looks crowded. Farther from transit than most of our options (Orange line is closest). Would be close to Franklin Park. It\'s certainly big enough.','I love the exterior.  It has the Tudor charm without the stuffiness.  Looking at the BRA map Chuck found, I think Walt is right that it is attached to the building next to it, with a tunnel thing over a common driveway.  Like Claybourne, the distance for the price is troubling.  Without knowing what the interior looks like, it is hard to find a reason to prioritize it.  I would also prefer more elbow room.  I really don\'t want forced hot air.  And are there services in the neighborhood easily by?','I really like the outside look of this. What is the interior like??? The lot is a little small for the size of the house.','Outside appearence good; forced hot air bad. Seems to be part of complex building with possibly 4 units. May have minimum room around it; almost the feel of an apartment building.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010532489','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2757885',42.3143,-71.0936,1);
INSERT INTO properties VALUES (83,70340955,'n','Floyd St, 73','?','7/3/1','7/3/1',3502,'y','y','?','0.54 (MS)',NULL,579900,'3/16 -- Deactivated by consensus\r\n\r\n\"Very Beautiful And Spacous 2-family With 7 Rooms Per Floor: 3large Bedrooms, Liv, Din , Kitchen, Plus An Extra Big Room. Basement Is Finished With 3 Rooms, A Full Bath , A Laundry Room, And A Full Walk-out Door.there Are Plenty Off-street Parkings, Plus One Car Garage With Access From The Basement.a Lot Of Potencial And Can Be Delivered Vacant If Prefered. ... Must See To Appreciate. Bring Your Buyer!!!\"\r\n\r\nBuilt in 1925.  0.12 acres.  Full finished walk out bament with garage access.  Basement under rear of house.  Shared driveway (?)  Wooden shingles.','This does not appeal to me and it is far from everything.','I don\'t like this.  Even trying to look beyond the clutter, we can do so much better than one box on top of another on top of a garage.  Especially for the price.','I agree with C & J on this - expensive and I don\'t see any positives except the size per se.','The present interior decoration makes it difficult to visualize this place.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010543938','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2773744',42.2886,-71.0871,1);
INSERT INTO properties VALUES (84,70343071,'n','Julian St, 24','?','6/4/2','8/4/2',3500,'y','n','y','0.39 (UC)',NULL,609900,'3/17: Deactivated by consensus after outside view.  Very much not worth the price.  A tremendous amount of paving.\r\n\r\n\"NEW CONSTRUCTION COMPLETED \'06. All the bells and whistles one expects in new construction. From gleaming hardwoods to spacious up-to-date open floor plans. PERFECT for entertaiing yet intimate for day-to-day high-style comfortable living. This new building may also be available as condos.\"\r\n\r\nBuilt in 2006.  0.08 acres.  100 amps/natural gas.  Partially finished partial basement with interior access.  Fenced yard.','I am not opposed to new construction, but I am not particularly drawn to this either, especially given the location and price. They could at least tempt us with kitchen pictures.','Ditto Chuck, though I lean a bit more away from newer things unless they are very special.  Also, I note that the walk from this street to Uphams Corner is an especially windy one, making the distance likely much longer.  Not on my list.','Nor on mine. Awfully expensive, windows look small from the outside, ceilings low. ','For this price they could have hired someone that would have paid attention to the outside appearance. The only attraction for me is that the utilities would not (presumably) need updating.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010547652','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2778981',42.3195,-71.0763,1);
INSERT INTO properties VALUES (85,70346595,'n','Elmer Rd, 84','Adams Village','5/2/1','8/4/1',3631,'y','y','?','0.36 (A)',1142226000,549000,'3/16 -- Deactivated by consensus\r\n\r\nThe unit distribution is correct.  This description is from the listing agent\'s webpage: \"Great 2 family house in the Adams Village area! The first floor unit, currently rented for $1,250, has 2 bedrooms, one bath, kitchen, diningroom and livingroom. The second floor unit has 3 bedrooms, livingroom, kitchen, diningroom, den and bonus family room. The manicured front and back yards are a great feature. There is a long driveway with garage and workshop. The screen house in the back yard has electricity, phone and cable - a great place to entertain or relax.\"\r\n\r\nHere is the link: http://bostonschoicerealestate.com/featured.html\r\n\r\nMLS description: \"Come See The Best Kept Home In Dorchester! This 2 Family Is Located Close To Ashmont T, Adams St Library, Adams Village, 93, Shopping - Everything You Could Need. Plenty Of Storage In Both Units. The Front And Back Yard Are Impeccably Maintained. The Back Yard Has An Outdoor Patio And A Screen House With Cable, Electricity And Phone Hook Up. Imagine Great Gatherings Of Friends In Family In This Friendly Neighborhood.\"\r\n\r\nBuilt in 1920.  0.12 acres.  Garage.  Porch and patio.  Rear yard screen house with utilities.','Sounds nice, and looks like it should be an easy walk to Ashmont. Have seen a picture from the realtor\'s site and it doesn\'t appeal, though. Boxy and the front looks kind of like a war memorial to me.','I worry about the instinct to fully wire an outside patio retreat space.  After seeing the exterior, I am not as intrigued.  Boxy and filling a small lot.','The exterior really turns me off.','The description pushes almost all of my positive buttons. Will see photos soon, I assume.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010553587','http://bostonschoicerealestate.com/images/FH1.jpg',42.2867,-71.058,1);
INSERT INTO properties VALUES (95,70353447,'y','Kenwood St, 36','Melville Park','11/5/3','',3000,'y','n','y','0.24 (S)',1143176400,599000,'\"Melville Park -thoroughly Reno. Lg Vict,arch.det, Nat.wd,stained Glass,new Sys.incl.radiant Heat And Ac, Everything Top-of-line. New Kit And Baths, 2-room Mstr Or 3rd Flr Suite W/huge Bath With Lg.whirlpool And Sep.shower. New Roof, Furnace, Electric. Basement Has Been Finished With Exercise Rm, Laundry, Family Room - Could Be Inlaw Or Entertainment Area.\"\r\n\r\nBuilt in 1890.  0.14 acres.  Full finished intererior access basement.  Sump pump.  Hot water basedboaed and radiator heat.  Radiant heat (does it mean in floor?).  Central air.  Natural gas/200 amps.  1 fireplace.  Paved driveway. Porch & deck.  Fenced yard.  Security system.  Wooden clapboard.  This has 2 full and 2 half baths (not counting basement).','Radiant heat! Some conversion costs we could choose to skip - we don\'t need to split the electrical, for instance. To me, this one is worth a serious talk about living with it unconverted for a time if that\'s what\'s necessary to foot the cost.',NULL,'This is certainly gorgeous and the description of the inside sounds great. The issues are price and the cost of conversion of course. The lot size is also a positive. And location is great.','VERY attractive. But how costly would it be to convert to a 2F. Really like the appearance. Is there a full bath on the first floor? Is there a kitchen on the second floor? Would feel really good walking back to this place if it were my home.',NULL,'http://www.newenglandmoves.com/Listings/SingleFamily_NewEnglandMoves.htm?id=1010566035','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2802041',42.2922,-71.07,1);
INSERT INTO properties VALUES (96,70355053,'y','Mather St, 52','Melville Park','5/3/1','5/3/1',2252,'y','n','y','0.04 (S)',1143608400,469900,'\"Desirable Melville Park Neighborhood!!! Mint Condition Duplex With All New Windows, Updated Kitchen Opens To Diningroom, Remodeled Baths, Queen Size Bedrooms, Exterior Newly Painted, Cb Wiring, Gleaming Pine And Maple Floors, Nice Detailing Throughout, High Ceilings, Mansard Roof, Landscaped, Fenced Yard With Brick Patio. Close To New Shawmut T Station. Great Price For This Wise Investment!\"\r\n\r\nBuilt in 1900.  0.13 acres.  Brick path and patio.  Wooden shingles.  Fenced yard.  Full walk out basement.  New windows.  Natural gas/\"new wiring\"','Large lot and the location is just unbelievable. The pictures look great inside and it seems to have a nice flow between rooms that might make the low square footage work. Two levels each is not really different from the Philly style buildings for accessibility, and the connected back porch looks attractive to me. I love the brick patio. And the price is certainly right.',NULL,NULL,NULL,NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_NewEnglandMoves.htm?id=1010568221','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2806260',42.2937,-71.0663,1);
INSERT INTO properties VALUES (89,70349444,'n','King St, 83','?','4/2/1','9/5/1',2632,'y','y','n','0.50 (S)',1142571600,550000,'3/19 deactivated:  In poor repair and far from transit, so not a good choice comparatively to other available options.\r\n\r\nOnly Remax has photos for now.\r\n\r\n\"Great Investment Opportunity! Very Large 3 Family Home With Large Bright Rooms. This Property Does Need Some Tlc And The Owner Will Be Doing The Repairs. \r\nHardwood Flooring, Has Finished Basement With 2 Bedrooms And One Bath, Delead Certificate For The Second Floor, Close To Public Transportion And Shopping!\"\r\n\r\nBuilt in 1910.  0.16 acres.  Full, partially finished basement.  New windows.  Vinyl sided.  Vinyl sided and brick.  Unit 2 is 2 levels.  Paved drive and 1 car garage.',NULL,NULL,NULL,NULL,NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010558046','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2792107_00',42.2933,-71.0558,1);
INSERT INTO properties VALUES (90,70335674,'y','Fuller St, 104','Ashmont','4/2/1','6/3/1',3037,'y','n','y','0.35 (A)',1140670800,565000,'3/26 update after inside tour -- This house is off the list.  The set up is inverse from our preferences, with the larger unit on the first floor.  It has its charms, but if anything the \"improvements\" since September have made is less attractive.  Certainly not at the price.\r\n\r\nWhich unit is on the ground floor is unclear.\r\n\r\n\"Come And See This Beautiful Early Century Home With Original Details, Huge Stained Glass Window Over Staircase To Second Level Of Townhouse Style Owner\'s Unit. Large Backyard, Private Rear Decks With Off Street Parking To Accomodate 4 Automobiles. Deleaded With Separate Utilities. Basement Is Finished And Has Private Entrance. New Heating System. Updated Electric. Close To Public Transportation. Seller Is Very Motivated. All Offers Will Be Considered.\"\r\n\r\nBuilt in 1905.  0.16 acres.  updated electric/natural gas.  Radiators.  Wooden shingles.  Lead paint certs.  Full finished basement with private entrance.',NULL,'If the first floor is smaller, this could be an option.  With 3037 sf, I want to believe the 4/2/1 is large enough.  And my understandng is that the finished basement is in addition to the two units, so perhaps some of that could be useful.  The finishes are very nice.  The distance to transit is good, though the area is more industrial feeling near Ashmont.    Hill up from the station is not as gentle as would be ideal.  The price seems to be about $20,000 too high, comparatively, given location and outside appearances.  Does the interior make up for that?','The pictures of the inside are certainly gorgeous. Of course I\'d like to get inside to see how big the 4/2/1 is. And your comments about what the outside was like on a drive by were somewhat disconcerting. ','Hard to comment. Available interior pictures are very attractive, look very formal; don\'t know how that would match our informal style. If sq.ft can be trusted, 4 rooms in Unit 1 may be adequate, with basement refuge.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010535473','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2761906',42.2821,-71.0705,1);
INSERT INTO properties VALUES (92,70351145,'y','Adams St, 331','Fields Corner','7/4/1','7/4/1',3017,'y','y','y','0.28 (FC)',1143003600,569000,'\"Great Duplex Close To Public Transportation And Shopping. Easy To Show, One Vacancy For New Owner. Town House Style With 4 Bedrooms Per Side. Spacious Units Good For Condo Conversion Or Owner Occupant.\"\r\n\r\nBuilt in 1900.  0.09 acres.  Full walkout concrete basement with interior access.  Wooden clapboard.  100 amps/natural gas.  *Forced hot air*  New windows.  Both units are three levels.  There is a paved drive for up to 6 cars.  There is currently a tenant in one unit.','Town house style seems less than ideal. Would apparently have to deal with evicting someone from the other half of it - ugh. Looks pretty outside though.','Close to Fields Corner.  Similar to Lindsey, but think I prefer the Philly style.  I am interested and want to see more.  That side of Dot Ave near Fields Corner is unknown to me.  Interior and yard?','The interior\'s the question, of course. I agree with Jenn that Lindsey\'s floor plan is preferable. Number of rooms and square footage sounds appropriate. The outside is pleasant. Lots of unknowns at this point.','Taxes $988 a year? Present tenant willing to leave? Don\'t like forced hot air but may lend itself to central AC. Looks like space on either side, but lot size is small. Inside a mystery','It\'s right on a rather busy intersection of Adams.  Definitely lacks the quaintness and quiet of all of the other listings.  Each time I\'ve driven by there has been a cop car parked in the garage/lot 5 yards away.','http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010561210','http://homepics.realtor.com/image8/http/mlspin/listings/large/063/70351145b.jpg',42.298,-71.0571,1);
INSERT INTO properties VALUES (93,70352847,'n','Saxton St, 20','Savin Hill','5/2/1','6/3/1',3474,'y','n','?','0.14 (SH)',1143262800,464900,'3/28/06 Under agreement\r\n\r\n\"Location!location!location! This Two-family House Is Only Minutes From Savin Hill T Station. Original Hardwood Floors Throughout The House. Second Floor Apartment Is Currently Vacant. Please Call List Agent And Make An Appoint To See It Today. Easy To Show.\"\r\n\r\nBuilt in 1905.  0.07 acres.  Full basement.  Natural gas/no electric info. other than fuses in use.  Vinyl siding.','This part of Savin Hill seems more residential and where Savin Hill Ave meets Dot. Ave there are definitely services. Plus very close to the T. Also cheap; if the inside wasn\'t a disaster we could spruce up the outside. My guess, though, is that the inside will need work as well because they just mention the hardwood floors.','Unlike Church St., it is east of Dot ave, so the walk to the station is easy/less grim.  But, it is not \"Over the Bridge,\" so may be a more friendly neighborhood.  We would like to see it.','Outside\'s not thrilling but I like the bay on the side. Square footage sounds good, and no. of rooms ok. Certainly worth a look.','This is another one that doesn\'t want to give anything away about what it is like inside. I guess that means there is nothing noteworthy about the inside, but could be OK - \"Please come and take a look\". Outside OK, location seems OK, room count and sq.ft. look promising. Electrical needs to be checked.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010565075','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2800470',42.3131,-71.0547,1);
INSERT INTO properties VALUES (94,70352644,'n','Denvir St, 2','Ashmont','5/3/1','8/4/2',2777,'y','n','y','0.34 (A)',1143262800,479000,'3/28 update: Under agreement\r\n\r\n\"Great 2 Family With Lots Of Updates, Sellers Unit Features 4 Bedrooms With 2 Full Baths, Updated Kitchen, Pantry With Laundry, Enclosed Front Entry And 2nd Floor Rear Porch. Tenants Are Willing To Move. Off Street Parking For 3-4 Cars, Fenced Lot. A Great Deal For The Price.\"\r\n\r\nBuilt in 1900.  0.08 acres.  Natural gas/updated electric.  Newer windows.  Wooden shingles.  *Forced hot air*','It\'s not too expensive to repaint. :) Location seems nice enough. Perhaps on the small side.','In between Whitten and Van Winkle.  I think it could be a good comparison, especially for the price/square footage.  We would like to see it.','The exterior makes me wince a little. It also sounds as if it could be small, given sq.footage. But the price is a positive and some of the details sound attractive.','Present owner color blind or from a different culture. I would close my eyes and use a white cane when coming home. Looks as though there is access to light.Inside is a mystery. Lots of rooms for less than 3000 sq.ft. On a short street, which could be a plus.',NULL,'http://www.newenglandmoves.com/Listings/MultiFamily_Non_NewEnglandMoves.htm?id=1010564992','http://images.nemoves.com/image/show?vd=mlsr&width=320&height=240&q=0.91&file=2800387',42.2892,-71.062,1);
