<?php

// We need the location of a working Horde installation to take
// advantage of several things that Horde offers (CSS, Javascript,
// etc).
@define('HORDE_BASE', dirname(__FILE__) . '/../../..');

// Load the core Horde libraries.
include_once HORDE_BASE . '/lib/core.php';

// Pretty exception handler since this is dev code. Don't include this
// in production, it exposes too much (stack traces, etc).
include_once 'Horde/Exception/Handler.php';
Horde_Exception_Handler::$config->debug = true;

// RDO does most of the data access magic. The next two files are
// helpers that integrate RDO with Horde_Form and Horde_Template for
// very quickly building basic applications. They're not part of RDO
// yet, but they're in CVS in the Horde incubator.
include_once 'Horde/RDO.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Form.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Table.php';

// Variable set class.
include_once 'Horde/Variables.php';

// Instantiate a registry object - at the core of Horde.
$registry = Registry::singleton();

// Notifications that are preserved past page loads.
$notification = &Notification::singleton();
$notification->attach('status');

/**
 * This is the class which rows of our table are instantiated
 * as. Later it'll get some helper methods and more functionality. For
 * now it just needs to exist.
 */
class Property extends Horde_RDO {
}

/**
 * RDO_Mapper is what deals with groups of data - rows. It's what you
 * get Property objects from. All you need to do in the subclass is
 * make sure that the database table is defined, and tell it how to
 * get a database connection.
 */
class PropertyMapper extends Horde_RDO_Mapper {

    protected $_table = 'properties';

    public function getAdapter()
    {
        require_once 'Horde/RDO/Adapter.php';
        include dirname(__FILE__) . '/../conf.php';
        return Horde_RDO_Adapter::factory('pdo', $sql);
    }

}

$pm = new PropertyMapper();
$self_url = Horde::selfUrl();
$filter = Util::getFormData('filter', array());
$title = 'Property Tracker';

$vars = Variables::getDefaultVariables();
$form = new Horde_Form_Helper($pm, $vars, $title);

$action = Util::getFormData('action');
switch ($action) {
case 'search':
    $form->getInfo($vars, $filter);
    unset($filter['action']);
    foreach ($filter as $key => $value) {
        if (empty($value)) {
            unset($filter[$key]);
        }
    }
    $self_url = Util::addParameter($self_url, 'action', 'search');
    break;
}

Horde::addScriptFile('stripe.js', 'horde', true);
include $registry->get('templates', 'horde') . '/common-header.inc';

$table = Horde_Table_Helper::factory('RDO', array('filter' => $filter,
                                                  'delete' => false,
                                                  'update' => false,
                                                  'create' => false), $pm);
$table->fill();
echo $table->fetch();

if (in_array($action, array('search'))) {
    $form->renderActive(new Horde_Form_Renderer(), $vars);
}

include $registry->get('templates', 'horde') . '/common-footer.inc';
