<?php

@define('HORDE_BASE', dirname(__FILE__) . '/../../..');
include_once HORDE_BASE . '/lib/core.php';
include_once 'Horde/Exception/Handler.php';
Horde_Exception_Handler::$config->debug = true;
include_once 'Horde/RDO.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Form.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Table.php';
include_once 'Horde/Variables.php';

// We've added Date_Calc for calculating number of days on the market.
include_once 'Date/Calc.php';

$registry = Registry::singleton();
$notification = &Notification::singleton();
$notification->attach('status');

class Property extends Horde_RDO {
}

class PropertyLens extends Horde_RDO_Lens {

    /**
     * This class decorates the RDO_List objects that our template
     * generates so that we can format the template output.
     */
    public function __get($key)
    {
        switch ($key) {
        case 'expansion':
        case 'garage':
        case 'renovated':
        case 'shortlist':
            switch (parent::__get($key)) {
            case 'y':
                return 'Yes';
            case 'n':
                return 'No';
            default:
                return '?';
            }
            break;

        case 'price':
            return '$' . number_format(parent::__get($key));

        case 'date':
            $val = parent::__get($key);
            return ($val ? Date_Calc::dateDiff(date('j'), date('n'), date('Y'),
                                               date('j', $val), date('n', $val), date('Y', $val)) : '');

        default:
            return parent::__get($key);
        }
    }

}

class PropertyMapper extends Horde_RDO_Mapper {

    protected $_table = 'properties';

    /**
     * formMeta() is a helper method used by Horde_Form_Helper and
     * Horde_Table_Helper to give better names to fields. All of our
     * types are determined correctly by Horde_RDO_Model, but we do
     * want to specify different human names for a number of fields.
     */
    public function formMeta()
    {
        $data['mls'] = array('humanName' => _("MLS #"));
        $data['shortlist'] = array('humanName' => _("Seen Inside?"));
        $data['address'] = array('humanName' => _("Address"));
        $data['neighborhood'] = array('humanName' => _("Nbhd"));
        $data['unit_1'] = array('humanName' => _("Unit #1"));
        $data['unit_2'] = array('humanName' => _("Unit #2"));
        $data['sf'] = array('humanName' => _("Sq. Ft."));
        $data['expansion'] = array('humanName' => _("Bsmt/ Attic"));
        $data['garage'] = array('humanName' => _("Garage"));
        $data['renovated'] = array('humanName' => _("Recent Upd"));
        $data['mbta'] = array('humanName' => _("MBTA"));
        $data['date'] = array('humanName' => _("DOM"));
        $data['price'] = array('humanName' => _("Price"));

        return $data;
    }

    public function getAdapter()
    {
        require_once 'Horde/RDO/Adapter.php';
        include dirname(__FILE__) . '/../conf.php';
        return Horde_RDO_Adapter::factory('pdo', $sql);
    }

}

$pm = new PropertyMapper();
$self_url = Horde::selfUrl();
$title = 'Property Tracker';

$vars = Variables::getDefaultVariables();
$form = new Horde_Form_Helper($pm, $vars, $title);

Horde::addScriptFile('stripe.js', 'horde', true);
include $registry->get('templates', 'horde') . '/common-header.inc';

if ($vars->get('action') != 'create') {
    $t_params = array(
        'create' => false,
        'update' => false,
        'delete' => false,
        // Sort by mls number initially.
        'sort' => 'mls',
        // Data formatter.
        'decorator' => 'PropertyLens',
        // We restrict the data that's shown in the table by passing
        // an array of columns.
        'columns' => array(
            'mls',
            'shortlist',
            'address',
            'neighborhood',
            'unit_1',
            'unit_2',
            'sf',
            'expansion',
            'garage',
            'renovated',
            'mbta',
            'date',
            'price',
            ));
    $table = Horde_Table_Helper::factory('RDO', $t_params, $pm);
    $table->fill();
    echo $table->fetch();
}

if (in_array($vars->get('action'), array('search', 'create'))) {
    $form->renderActive(new Horde_Form_Renderer(), $vars);
}

include $registry->get('templates', 'horde') . '/common-footer.inc';
