<?php

@define('HORDE_BASE', dirname(__FILE__) . '/../../..');
include_once HORDE_BASE . '/lib/core.php';
include_once 'Horde/Exception/Handler.php';
Horde_Exception_Handler::$config->debug = true;
include_once 'Horde/RDO.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Form.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Table.php';
include_once 'Horde/Variables.php';
include_once 'Date/Calc.php';

$registry = Registry::singleton();
$notification = &Notification::singleton();
$notification->attach('status');

class Property extends Horde_RDO {
}

class PropertyMapper extends Horde_RDO_Mapper {

    protected $_table = 'properties';

    /**
     * Specify the fields that are part of add/edit forms. We skip
     * comments and several calculated values.
     */
    public function formFields()
    {
        return array('mls', 'shortlist', 'address', 'neighborhood', 'unit_1', 'unit_2',
                     'sf', 'expansion', 'garage', 'renovated', 'date', 'price', 'description',
                     'url', 'photo', 'active');
    }

    public function formMeta()
    {
        // We've added data for several more form types, and also
        // added 'type' attributes. For complicated types, like enums,
        // we've added additonal parameters.

        // We reuse the yes/no/unknown params for a few fields.
        $ynenum = array('?' => '?', 'y' => 'Yes', 'n' => 'No');

        $data['mls'] = array('humanName' => _("MLS #"));
        $data['shortlist'] = array('humanName' => _("Seen Inside?"), 'type' => 'enum', 'params' => array(array('y' => 'Yes', 'n' => 'No')));
        $data['address'] = array('humanName' => _("Address"));

        $neighborhoods = array('?' => '?',
                               'Adams Village' => 'Adams Village',
                               'Ashmont' => 'Ashmont',
                               'Ashmont Hill' => 'Ashmont Hill',
                               'Clam Point' => 'Clam Point',
                               'Fields Corner' => 'Fields Corner',
                               'Jones Hill' => 'Jones Hill',
                               'Melville Park' => 'Melville Park',
                               'Ronan Park' => 'Ronan Park',
                               'Savin Hill' => 'Savin Hill',
                               'Shawmut' => 'Shawmut',
                               'Uphams Corner' => 'Uphams Corner');
        $data['neighborhood'] = array('humanName' => _("Nbhd"), 'type' => 'enum', 'params' => array($neighborhoods));
        $data['unit_1'] = array('humanName' => _("Unit #1"));
        $data['unit_2'] = array('humanName' => _("Unit #2"));
        $data['sf'] = array('humanName' => _("Sq. Ft."));
        $data['expansion'] = array('humanName' => _("Bsmt/ Attic"), 'type' => 'enum', 'params' => array($ynenum));
        $data['garage'] = array('humanName' => _("Garage"), 'type' => 'enum', 'params' => array($ynenum));
        $data['renovated'] = array('humanName' => _("Recent Upd"), 'type' => 'enum', 'params' => array($ynenum));
        $data['mbta'] = array('humanName' => _("MBTA"));
        $data['date'] = array('humanName' => _("DOM"), 'type' => 'monthdayyear', 'params' => array(2005));
        $data['price'] = array('humanName' => _("Price"));
        $data['description'] = array('humanName' => _("Description"), 'type' => 'longtext');
        $data['active'] = array('humanName' => 'Active?', 'type' => 'enum', 'params' => array(array(1 => 'Active', 0 => 'Inactive')));

        return $data;
    }

    public function getAdapter()
    {
        require_once 'Horde/RDO/Adapter.php';
        include dirname(__FILE__) . '/../conf.php';
        return Horde_RDO_Adapter::factory('pdo', $sql);
    }

}

$pm = new PropertyMapper();
$action = Util::getFormData('action');
$self_url = Horde::selfUrl();
$title = 'Property Tracker';

$vars = Variables::getDefaultVariables();
$form = new Horde_Form_Helper($pm, $vars, $title);

switch ($action) {
case 'delete':
    $test = $form->getSelected();
    $test->delete();
    $notification->push(_("Deleted"), 'horde.success');
    header('Location: ' . $self_url);
    exit;

case 'create':
    if (!$form->validate($vars)) {
        break;
    }
    $form->getInfo($vars, $info);
    unset($info['action']);
    $pm->create($info);
    $notification->push(_("Created"), 'horde.success');
    header('Location: ' . $self_url);
    exit;

case 'update':
    $test = $form->getSelected();
    if (!$form->isSubmitted($vars)) {
        foreach ($test as $key => $value) {
            $vars->set($key, $value);
        }
    } elseif ($form->validate($vars)) {
        $form->getInfo($vars, $info);
        unset($info['update_id'], $info['action']);
        $test->setFields($info);
        $pm->update($test);
        $notification->push(_("Updated"), 'horde.success');
        header('Location: ' . $self_url);
        exit;
    }
    break;
}

Horde::addScriptFile('stripe.js', 'horde', true);
include $registry->get('templates', 'horde') . '/common-header.inc';

if (!in_array($action, array('create', 'update'))) {
    $table = Horde_Table_Helper::factory('RDO', array('sort' => 'mls',
                                                      'columns' => array(
                                                         'mls',
                                                         'shortlist',
                                                         'address',
                                                         'neighborhood',
                                                         'unit_1',
                                                         'unit_2',
                                                         'sf',
                                                         'expansion',
                                                         'garage',
                                                         'renovated',
                                                         'mbta',
                                                         'date',
                                                         'price',
                                                         )), $pm);
    $table->fill();
    echo $table->fetch();
}

if (in_array($action, array('create', 'update', 'search'))) {
    $form->renderActive(new Horde_Form_Renderer(), $vars);
}

include $registry->get('templates', 'horde') . '/common-footer.inc';
