<?php

@define('HORDE_BASE', dirname(__FILE__) . '/../../..');
include_once HORDE_BASE . '/lib/core.php';
include_once 'Horde/Exception/Handler.php';
Horde_Exception_Handler::$config->debug = true;
include_once dirname(dirname(__FILE__)) . '/Helpers/Form.php';
include_once dirname(dirname(__FILE__)) . '/Helpers/Table.php';
include_once 'Horde/Variables.php';
include_once 'Date/Calc.php';
include_once './lib/Property.php';

$registry = Registry::singleton();
$notification = &Notification::singleton();
$notification->attach('status');

$pm = new PropertyMapper();
$action = Util::getFormData('action');
$self_url = Horde::selfUrl();
$title = 'Property Tracker';

$vars = Variables::getDefaultVariables();
$form = new Horde_Form_Helper($pm, $vars, $title);

switch ($action) {
case 'delete':
    $test = $form->getSelected();
    $test->delete();
    $notification->push(_("Deleted"), 'horde.success');
    header('Location: ' . $self_url);
    exit;

case 'create':
    if (!$form->validate($vars)) {
        break;
    }
    $form->getInfo($vars, $info);
    unset($info['action']);
    $pm->create($info);
    $notification->push(_("Created"), 'horde.success');
    header('Location: ' . $self_url);
    exit;

case 'update':
    $test = $form->getSelected();
    if (!$form->isSubmitted($vars)) {
        foreach ($test as $key => $value) {
            $vars->set($key, $value);
        }
    } elseif ($form->validate($vars)) {
        $form->getInfo($vars, $info);
        unset($info['update_id'], $info['action']);
        $test->setFields($info);
        $pm->update($test);
        $notification->push(_("Updated"), 'horde.success');
        header('Location: ' . $self_url);
        exit;
    }
    break;
}

if (!in_array($action, array('create', 'update'))) {
    $table = Horde_Table_Helper::factory('RDO', array('sort' => 'mls',
                                                      'perpage' => 100,
                                                      'delete' => false,
                                                      'update' => false,
                                                      'export' => false,
                                                      'decorator' => 'PropertyLens',
                                                      'columns' => array('mls','shortlist','address','neighborhood','unit_1','unit_2','sf','expansion','garage','renovated','mbta','date','price')),
                                         $pm);
    $table->fill();
    $table->set('active', $pm->count(array('active' => 1)));
    echo $table->fetch('./template.html');
} else {
    $form->setTitle('');
    $template = new Horde_Template();
    $template->set('title', $action == 'create' ? _("New Property") : _("Edit Property"));
    $template->set('form', Util::bufferOutput(array($form, 'renderActive'), new Horde_Form_Renderer(), $vars));
    echo $template->fetch('./form.html');
}
