<?php

include_once 'Horde/RDO.php';
include_once dirname(dirname(dirname(__FILE__))) . '/Helpers/Lens.php';

class Property extends Horde_RDO {
    public function getAddress()
    {
        if (strpos($this->address, ',') === false) {
            return $this->address;
        }
        $parts = explode(',', $this->address, 2);
        return trim($parts[1]) . ' ' . trim($parts[0]);
    }
}

class PropertyLens extends Horde_RDO_Lens {
    public function __get($key)
    {
        switch ($key) {
        case 'expansion':
        case 'garage':
        case 'renovated':
        case 'shortlist':
            switch (parent::__get($key)) {
            case 'y':
                return 'Yes';
            case 'n':
                return 'No';
            default:
                return '?';
            }
            break;

        case 'price':
            return '$' . number_format(parent::__get($key));

        case 'date':
            $val = parent::__get($key);
            return ($val ? Date_Calc::dateDiff(date('j'), date('n'), date('Y'),
                                               date('j', $val), date('n', $val), date('Y', $val)) : '');

        default:
            return parent::__get($key);
        }
    }
}

class PropertyMapper extends Horde_RDO_Mapper {

    protected $_table = 'properties';

    public function formFields()
    {
        return array('mls', 'shortlist', 'address', 'neighborhood', 'unit_1', 'unit_2',
                     'sf', 'expansion', 'garage', 'renovated', 'date', 'price', 'description',
                     'url', 'photo', 'active');
    }

    public function formMeta()
    {
        $ynenum = array('?' => '?', 'y' => 'Yes', 'n' => 'No');

        $data['mls'] = array('humanName' => _("MLS #"));
        $data['shortlist'] = array('humanName' => _("Seen Inside?"), 'type' => 'enum', 'params' => array(array('y' => 'Yes', 'n' => 'No')));
        $data['address'] = array('humanName' => _("Address"));

        $neighborhoods = array('?' => '?',
                               'Adams Village' => 'Adams Village',
                               'Ashmont' => 'Ashmont',
                               'Ashmont Hill' => 'Ashmont Hill',
                               'Clam Point' => 'Clam Point',
                               'Fields Corner' => 'Fields Corner',
                               'Jones Hill' => 'Jones Hill',
                               'Melville Park' => 'Melville Park',
                               'Ronan Park' => 'Ronan Park',
                               'Savin Hill' => 'Savin Hill',
                               'Shawmut' => 'Shawmut',
                               'Uphams Corner' => 'Uphams Corner');
        $data['neighborhood'] = array('humanName' => _("Nbhd"), 'type' => 'enum', 'params' => array($neighborhoods));
        $data['unit_1'] = array('humanName' => _("Unit #1"));
        $data['unit_2'] = array('humanName' => _("Unit #2"));
        $data['sf'] = array('humanName' => _("Sq. Ft."));
        $data['expansion'] = array('humanName' => _("Bsmt/ Attic"), 'type' => 'enum', 'params' => array($ynenum));
        $data['garage'] = array('humanName' => _("Garage"), 'type' => 'enum', 'params' => array($ynenum));
        $data['renovated'] = array('humanName' => _("Recent Upd"), 'type' => 'enum', 'params' => array($ynenum));
        $data['mbta'] = array('humanName' => _("MBTA"));
        $data['date'] = array('humanName' => _("DOM"), 'type' => 'monthdayyear', 'params' => array(2005));
        $data['price'] = array('humanName' => _("Price"));
        $data['description'] = array('humanName' => _("Description"), 'type' => 'longtext');
        $data['active'] = array('humanName' => 'Active?', 'type' => 'enum', 'params' => array(array(1 => 'Active', 0 => 'Inactive')));

        return $data;
    }

    public function getAdapter()
    {
        require_once 'Horde/RDO/Adapter.php';
        include dirname(__FILE__) . '/../../conf.php';
        return Horde_RDO_Adapter::factory('pdo', $sql);
    }

}
