/**
 * Component for filtering a table or any list of children based on
 * the dynamic value of a text input. It requires the prototype.js
 * library.
 *
 * You should define the CSS class .QuickFinderNoMatch to say what
 * happens to items that don't match the criteria. A reasonable
 * default would be display:none.
 *
 * This code is heavily inspired by Filterlicious by Gavin
 * Kistner. The filterlicious JavaScript file did not have a license;
 * however, most of Gavin's code is under the license defined by
 * http://phrogz.net/JS/_ReuseLicense.txt, so I'm including that URL
 * and Gavin's name as acknowledgements.
 *
 * @author Chuck Hagenbuch <chuck@horde.org>
 *
 * $Horde: presentations/nyphpcon-2006-06/v7/js/QuickFinder.js,v 1.1 2006/06/22 17:09:54 chuck Exp $
 */

var QuickFinder = {

    attachBehavior: function()
    {
        var inputs = document.getElementsByTagName('input');
        for (var i = 0, length = inputs.length; i < length; ++i) {
            var input = inputs[i];
            filterTarget = input.getAttribute('for');
            if (!filterTarget) {
                continue;
            }

            input.filterTarget = $(filterTarget);
            if (!input.filterTarget) {
                continue;
            }

            filterEmpty = input.getAttribute('empty');
            if (filterEmpty) {
                input.filterEmpty = $(filterEmpty);
            }

            Event.observe(input, 'keyup', QuickFinder.onKeyUp.bindAsEventListener(QuickFinder), false);

            var lines = input.filterTarget.childNodes;
            for (var j = 0, llength = lines.length; j < llength; ++j) {
                var line = lines[j];
                if (!line.getAttribute) {
                    continue;
                }

                var filterText = line.filterText || line.getAttribute('filterText');
                if (!filterText) {
                    line.filterText = line.innerHTML.stripTags();
                }
                line.filterText = line.filterText.toLowerCase();
            }

            QuickFinder.filter(input);
        }
    },

    onKeyUp: function(e)
    {
        input = Event.element(e);
        if (input.filterTarget) {
            QuickFinder.filter(input);
        }
    },

    filter: function(input)
    {
        var val = input.value.toLowerCase();
        var lines = input.filterTarget.childNodes;
        var matched = 0;
        for (var i = 0, length = lines.length; i < length; ++i) {
            var line = lines[i];
            if (!line.getAttribute) {
                continue;
            }

            var filterText = line.filterText;
            if (filterText.indexOf(val) == -1) {
                Element.addClassName(line, 'QuickFinderNoMatch');
            } else {
                matched++;
                Element.removeClassName(line, 'QuickFinderNoMatch');
            }
        }

        try {
            if (input.filterEmpty) {
                (matched == 0) ? Element.show(input.filterEmpty) : Element.hide(input.filterEmpty);
            }
        } catch (e) {}
    }

}

Event.observe(window, 'load', QuickFinder.attachBehavior);
