var icon = new GIcon();
icon.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
icon.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
icon.iconSize = new GSize(12, 20);
icon.shadowSize = new GSize(22, 20);
icon.iconAnchor = new GPoint(6, 20);
icon.infoWindowAnchor = new GPoint(5, 1);

var stations = {
    jfk_umass: [-71.05259656906128, 42.32133473804341, 'JFK/UMass (Red&nbsp;Line,&nbsp;Both&nbsp;Branches)'],
    savin_hill: [-71.05331003665924, 42.311344703300975, 'Savin&nbsp;Hill (Red&nbsp;Line,&nbsp;Ashmont)'],
    fields_corner: [-71.06193333864212, 42.29998821175855, 'Fields&nbsp;Corner (Red&nbsp;Line,&nbsp;Ashmont)'],
    shawmut: [-71.06564283370972, 42.29331023352116, 'Shawmut (Red&nbsp;Line,&nbsp;Ashmont)'],
    ashmont: [-71.06445997953415, 42.284629390608146, 'Ashmont (Red&nbsp;Line,&nbsp;Ashmont)'],
    ruggles: [-71.0895, 42.3345, 'Ruggles (Orange&nbsp;Line, Needham&nbsp;Commuter&nbsp;Rail)'],
    roxbury: [-71.094232, 42.331535, 'Roxbury&nbsp;Crossing (Orange&nbsp;Line)'],
    jackson: [-71.09807, 42.325001, 'Jackson&nbsp;Square (Orange&nbsp;Line)'],
    stony_brook: [-71.104282, 42.317137, 'Stony&nbsp;Brook (Orange&nbsp;Line)'],
    green_street: [-71.106754, 42.31057, 'Green&nbsp;Street (Orange&nbsp;Line)'],
    forest_hills: [-71.1135, 42.2999, 'Forest&nbsp;Hills (Orange&nbsp;Line, Needham&nbsp;Commuter&nbsp;Rail)'],
    uphams_corner: [-71.06881, 42.318487, 'Uphams&nbsp;Corner (Fairmount&nbsp;Commuter&nbsp;Rail)'],
    morton: [-71.08552, 42.280867, 'Morton&nbsp;St. (Fairmount&nbsp;Commuter&nbsp;Rail)']
};

var groceries = [
    [-71.068145, 42.301289, 'Fernandes&nbsp;Market'],
    [-71.071699, 42.291495, 'Tropical&nbsp;Foods'],
    [-71.049751, 42.317955, 'Star&nbsp;Market'],
    [-71.069651, 42.272164, 'Shaw\'s'],
    [-71.066143, 42.326158, 'Super&nbsp;Stop&nbsp;&amp;&nbsp;Shop'],
    [-71.082641, 42.30902, 'Super&nbsp;Stop&nbsp;&amp;&nbsp;Shop'],
    [-71.048233, 42.292317, 'Super&nbsp;Stop&nbsp;&amp;&nbsp;Shop']
];

var tIcon = new GIcon();
tIcon.image = "../graphics/t.png";
tIcon.shadow = "http://www.google.com/mapfiles/shadow50.png";
tIcon.iconSize = new GSize(20, 20);
tIcon.shadowSize = new GSize(37, 20);
tIcon.iconAnchor = new GPoint(9, 20);
tIcon.infoWindowAnchor = new GPoint(9, 2);
tIcon.infoShadowAnchor = new GPoint(18, 25);

var foodIcon = new GIcon();
foodIcon.image = "http://labs.google.com/ridefinder/images/mm_20_blue.png";
foodIcon.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
foodIcon.iconSize = new GSize(12, 20);
foodIcon.shadowSize = new GSize(22, 20);
foodIcon.iconAnchor = new GPoint(6, 20);
foodIcon.infoWindowAnchor = new GPoint(5, 1);

for (var i in stations) {
    var station = stations[i];
    var closure = { m: new GMarker(new GPoint(station[0], station[1]), tIcon),
                    t: station[2] }
    GEvent.addListener(closure.m, 'click', (function() {
        this.m.openInfoWindowHtml('<strong>' + this.t + '</strong>');
    }).bind(closure));
    map.addOverlay(closure.m);
}

for (var i in groceries) {
    var grocery = groceries[i];
    var closure = { m: new GMarker(new GPoint(grocery[0], grocery[1]), foodIcon),
                    t: grocery[2] }
    GEvent.addListener(closure.m, 'click', (function() {
        this.m.openInfoWindowHtml('<strong>' + this.t + '</strong>');
    }).bind(closure));
    map.addOverlay(closure.m);
}
