<?php

include_once 'Horde/RDO.php';
include_once dirname(dirname(dirname(__FILE__))) . '/Helpers/Lens.php';

class Property extends Horde_RDO {
    public function getAddress()
    {
        if (strpos($this->address, ',') === false) {
            return $this->address;
        }
        $parts = explode(',', $this->address, 2);
        return trim($parts[1]) . ' ' . trim($parts[0]);
    }
}

class PropertyLens extends Horde_RDO_Lens {
    public function __get($key)
    {
        switch ($key) {
        case 'expansion':
        case 'garage':
        case 'renovated':
        case 'shortlist':
            switch (parent::__get($key)) {
            case 'y':
                return 'Yes';
            case 'n':
                return 'No';
            default:
                return '?';
            }
            break;

        case 'price':
            return '$' . number_format(parent::__get($key));

        case 'date':
            $val = parent::__get($key);
            return ($val ? Date_Calc::dateDiff(date('j'), date('n'), date('Y'),
                                               date('j', $val), date('n', $val), date('Y', $val)) : '');

        default:
            return parent::__get($key);
        }
    }
}

class PropertyMapper extends Horde_RDO_Mapper {

    protected $_table = 'properties';

    public function formFields()
    {
        return array('mls', 'shortlist', 'address', 'neighborhood', 'unit_1', 'unit_2',
                     'sf', 'expansion', 'garage', 'renovated', 'date', 'price', 'description',
                     'url', 'photo', 'active');
    }

    public function formMeta()
    {
        $ynenum = array('?' => '?', 'y' => 'Yes', 'n' => 'No');

        $data['mls'] = array('humanName' => _("MLS #"));
        $data['shortlist'] = array('humanName' => _("Seen Inside?"), 'type' => 'enum', 'params' => array(array('y' => 'Yes', 'n' => 'No')));
        $data['address'] = array('humanName' => _("Address"));

        $neighborhoods = array('?' => '?',
                               'Adams Village' => 'Adams Village',
                               'Ashmont' => 'Ashmont',
                               'Ashmont Hill' => 'Ashmont Hill',
                               'Clam Point' => 'Clam Point',
                               'Fields Corner' => 'Fields Corner',
                               'Jones Hill' => 'Jones Hill',
                               'Melville Park' => 'Melville Park',
                               'Ronan Park' => 'Ronan Park',
                               'Savin Hill' => 'Savin Hill',
                               'Shawmut' => 'Shawmut',
                               'Uphams Corner' => 'Uphams Corner');
        $data['neighborhood'] = array('humanName' => _("Nbhd"), 'type' => 'enum', 'params' => array($neighborhoods));
        $data['unit_1'] = array('humanName' => _("Unit #1"));
        $data['unit_2'] = array('humanName' => _("Unit #2"));
        $data['sf'] = array('humanName' => _("Sq. Ft."));
        $data['expansion'] = array('humanName' => _("Bsmt/ Attic"), 'type' => 'enum', 'params' => array($ynenum));
        $data['garage'] = array('humanName' => _("Garage"), 'type' => 'enum', 'params' => array($ynenum));
        $data['renovated'] = array('humanName' => _("Recent Upd"), 'type' => 'enum', 'params' => array($ynenum));
        $data['mbta'] = array('humanName' => _("MBTA"));
        $data['date'] = array('humanName' => _("DOM"), 'type' => 'monthdayyear', 'params' => array(2005));
        $data['price'] = array('humanName' => _("Price"));
        $data['description'] = array('humanName' => _("Description"), 'type' => 'longtext');
        $data['active'] = array('humanName' => 'Active?', 'type' => 'enum', 'params' => array(array(1 => 'Active', 0 => 'Inactive')));

        return $data;
    }

    public function getAdapter()
    {
        require_once 'Horde/RDO/Adapter.php';
        include dirname(__FILE__) . '/../../conf.php';
        return Horde_RDO_Adapter::factory('pdo', $sql);
    }

}

// Turn $address into $long and $lat using Yahoo! geocoding.
function geocode($address, &$long, &$lat)
{
    include dirname(__FILE__) . '/../../conf.php';
    $url = 'http://api.local.yahoo.com/MapsService/V1/geocode?appid=' . $yahoo_api_key . '&street=' .
        urlencode($address) . '&city=Dorchester&state=MA&output=php';
    $data = @unserialize(file_get_contents($url));
    if ($data && !empty($data['ResultSet']['Result'])) {
        $res = $data['ResultSet']['Result'];
        $long = $res['Longitude'];
        $lat = $res['Latitude'];
    }
}

// Find the closest t stop to the given $longitude and $latitude and
// store it in $distance.
function mbta_distance($longitude, $latitude, &$distance)
{
    $stations = array(
        'jfk_umass' => array(-71.05259656906128, 42.32133473804341, 'JFK'),
        'savin_hill' => array(-71.05331003665924, 42.311344703300975, 'SH'),
        'fields_corner' => array(-71.06193333864212, 42.29998821175855, 'FC'),
        'shawmut' => array(-71.06564283370972, 42.29331023352116, 'S'),
        'ashmont' => array(-71.06445997953415, 42.284629390608146, 'A'),
        'ruggles' => array(-71.0895, 42.3345, 'R'),
        'roxbury' => array(-71.094232, 42.331535, 'RC'),
        'jackson' => array(-71.09807, 42.325001, 'JS'),
        'stony_brook' => array(-71.104282, 42.317137, 'SB'),
        'green_street' => array(-71.106754, 42.31057, 'GS'),
        'forest_hills' => array(-71.1135, 42.2999, 'FH'),
        'uphams_corner' => array(-71.06881, 42.318487, 'UC'),
        'morton' => array(-71.08552, 42.280867, 'MS'),
    );

    list($lat1, $long1) = parse_location($latitude . 'N,' . $longitude . 'W');

    $shortest = null;
    $stationid = null;
    foreach ($stations as $station) {
        list($lat2, $long2) = parse_location($station[1] . 'N,' . $station[0] . 'W');
        $distance = great_circle_distance($lat1, $long1, $lat2, $long2);
        if ($shortest === null || $distance < $shortest) {
            $shortest = $distance;
            $stationid = $station[2];
        }
    }

    $distance = number_format($shortest * 0.000621371192237334, 2) . ' (' . $stationid . ')';
}

// given coordinates of two places in radians, compute distance in meters
function great_circle_distance($lat1, $long1, $lat2, $long2)
{
    // approx radius of Earth in meters.  True radius varies from
    // 6357km (polar) to 6378km (equatorial).
    $earth_radius = 6367000;

    $dlon = $long2 - $long1;
    $dlat = $lat2 - $lat1;
    $a = pow((sin($dlat / 2)), 2) + cos($lat1) * cos($lat2) * pow((sin($dlon / 2)), 2);
    $d = 2 * atan2(sqrt($a), sqrt(1 - $a));

    // This is a simpler formula, but it's subject to rounding errors
    // for small distances.  See http://www.census.gov/cgi-bin/geo/gisfaq?Q5.1
    // my $d = acos(sin($lat1) * sin($lat2)
    //               + cos($lat1) * cos($lat2) * cos($long1-$long2));

    return $earth_radius * $d;
}

// convert a string which looks like "34:45:12N,15:34:10W" into a pair
// of degrees.  Also accepts "34.233N,90.134E" etc.
function parse_location($str)
{
    if (preg_match('/^([0-9:.\260\'"d -]*)([NS])[, ]+([0-9:.\260\'"d -]*)([EW])$/i', $str, $regs)) {
        if (!($lat = parse_degrees($regs[1]))) {
            return false;
        }
        $lat *= (($regs[2] == 'N' || $regs[2] == 'n') ? 1.0 : -1.0);
        if (!($long = parse_degrees($regs[3]))) {
            return false;
        }
        $long *= (($regs[4] == 'E' || $regs[4] == 'e') ? 1.0 : -1.0);
        return array(deg2rad($lat), deg2rad($long));
    }

    return false;
}

// convert a string like 34:45:12.34 or 38:40 or 34.124 or 34d45'12.34"
// or 25Â° 02' 30" to degrees
// (also handles a leading `-')
function parse_degrees($str)
{
    // yeah, this could probably be done with one regexp.
    if (preg_match('/^\s*(-?)([\d.]+)\s*(:|d|\260)\s*([\d.]+)\s*(:|\')\s*([\d.]+)\s*\"?\s*$/', $str, $regs)) {
        $sign = ($regs[1] == '-') ? -1.0 : 1.0;
        $d = $regs[2] + 0.0;
        $m = $regs[4] + 0.0;
        $s = $regs[6] + 0.0;
    } elseif (preg_match('/^\s*(-?)([\d.]+)\s*(:|d|\260)\s*([\d.]+)(\')?\s*$/', $str, $regs)) {
        $sign = ($regs[1] == '-') ? -1.0 : 1.0;
        $d = $regs[2] + 0.0;
        $m = $regs[4] + 0.0;
        $s = 0.0;
    } elseif (preg_match('/^\s*(-?)([\d.]+)(d|\260)?\s*$/', $str, $regs)) {
        $sign = ($regs[1] == '-') ? -1.0 : 1.0;
        $d = $regs[2] + 0.0;
        $m = 0.0;
        $s = 0.0;
    } else {
        return false;
    }

    return ($sign * ($d + ($m / 60.0) + ($s / 3600.0)));
}
