<?php

@define('HORDE_BASE', dirname(__FILE__) . '/../../..');
require HORDE_BASE . '/lib/core.php';
require './lib/Property.php';
require dirname(__FILE__) . '/../conf.php';

$id = (int)$_REQUEST['id'];
$pm = new PropertyMapper();
$prop = $pm->find($id);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html>
<head>
<title><?php echo htmlspecialchars($prop->getAddress()) ?></title>
<link type="text/css" rel="stylesheet" href="/tn.css" />
<link type="text/css" rel="stylesheet" href="pt.css" />
<script type="text/javascript" src="js/prototype.js"></script>
<script type="text/javascript" src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo htmlspecialchars($google_maps_key) ?>"></script>
<script type="text/javascript">
//<![CDATA[
Event.observe(window, 'load', function() {
    var map = new GMap(document.getElementById("map"));
    map.addControl(new GLargeMapControl());
    map.addControl(new GMapTypeControl());
    var point = new GPoint(<?php echo $prop->longitude ?>, <?php echo $prop->latitude ?>);
    map.centerAndZoom(point, 3);
    map.setMapType(G_HYBRID_TYPE);

<?php include './js/map.js' ?>


    var marker = new GMarker(point, icon);
    GEvent.addListener(marker, 'click', function() {
        marker.openInfoWindowHtml('<strong><?php echo addslashes(str_replace(' ', '&nbsp;', $prop->getAddress())) ?></strong>');
    });
    map.addOverlay(marker);
});
//]]>
</script>
</head>
<body>
<div id="map" style="width:auto; height:580px">Loading ...</div>
</body>
</html>
