<?php

@define('HORDE_BASE', dirname(__FILE__) . '/../../..');
require HORDE_BASE . '/lib/core.php';
require './lib/Property.php';
require dirname(__FILE__) . '/../conf.php';

$pm = new PropertyMapper();
$list = $pm->find(Horde_RDO::FIND_ALL, array('active' => 1));

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>All Properties</title>
<link type="text/css" rel="stylesheet" href="/tn.css" />
<link type="text/css" rel="stylesheet" href="pt.css" />
<script type="text/javascript" src="js/prototype.js"></script>
<script type="text/javascript" src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo htmlspecialchars($google_maps_key) ?>"></script>
<script type="text/javascript">
//<![CDATA[
var map;
Event.observe(window, 'load', function() {
    if (typeof GMap == 'undefined') {
        document.getElementById('map').innerHTML = 'Sorry, something is broken.';
        return;
    }

    map = new GMap(document.getElementById('map'));
    map.addControl(new GLargeMapControl());
    map.addControl(new GMapTypeControl());
    map.centerAndZoom(new GPoint(-71.0720157623291, 42.30194425310006), 4);
    map.setMapType(G_HYBRID_TYPE);

<?php include './js/map.js' ?>

<?php foreach ($list as $prop): if (!$prop->longitude || !$prop->latitude) continue; ?>
    var closure = { m: new GMarker(new GPoint(<?php echo $prop->longitude ?>, <?php echo $prop->latitude ?>), icon),
                    t: '<?php echo addslashes(str_replace(' ', '&nbsp;', $prop->getAddress())) ?>' }
    GEvent.addListener(closure.m, 'click', (function() {
        this.m.openInfoWindowHtml('<strong>' + this.t + '</strong>');
    }).bindAsEventListener(closure));
    map.addOverlay(closure.m);
<?php endforeach; ?>
});

var userAddress = null;
function findUserAddress()
{
    var address = $('useraddress').value;
    if (address.length == 0) {
        return;
    }

    new Ajax.Request('geocode.php?address=' + encodeURIComponent(address), { onComplete: mapUserAddress } );
}

function mapUserAddress(request)
{
    var result;
    try {
        eval('result = ' + request.responseText);
    } catch (e) {
        return;
    }

    clearUserAddress();
    $('mbta').innerHTML = result.distance;

    var closure = { m: new GMarker(new GPoint(result['long'], result['lat'])),
                    t: result.address.replace(' ', '&nbsp;') }
    userAddress = closure.m;
    GEvent.addListener(closure.m, 'click', (function() {
        this.m.openInfoWindowHtml('<strong>' + this.t + '</strong>');
    }).bindAsEventListener(closure));
    map.addOverlay(closure.m);
    map.centerAndZoom(new GPoint(result['long'], result['lat']), 3);
}

function clearUserAddress()
{
    $('mbta').innerHTML = '';
    if (userAddress != null) {
        map.removeOverlay(userAddress);
        userAddress = null;
    }
}
//]]>
</script>
</head>
<body>
<div id="map" style="width:auto; height:580px">Loading ...</div>

<form action="#" onsubmit="findUserAddress(); return false;">
<p style="margin-left:10px">
 Show Address (Dorchester, MA is assumed):
 <input type="text" id="useraddress" />
 <input type="submit" value="Show" />
 <input type="button" value="Clear" onclick="clearUserAddress();" />
 <br />
 <span id="mbta" />
</p>
</form>

</body>
</html>
